"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var DropdownMenu_exports = {};
__export(DropdownMenu_exports, {
  CheckboxItem: () => CheckboxItem,
  Content: () => Content,
  Group: () => Group,
  Indicator: () => Indicator,
  Item: () => Item,
  RadioItem: () => RadioItem,
  Root: () => Root,
  Sub: () => Sub,
  SubContent: () => SubContent,
  SubTrigger: () => SubTrigger,
  Trigger: () => Trigger
});
module.exports = __toCommonJS(DropdownMenu_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var DropdownMenu = __toESM(require("@radix-ui/react-dropdown-menu"));
var import_editor = require("@tldraw/editor");
var import_useMenuIsOpen = require("../../hooks/useMenuIsOpen");
var import_Button = require("./Button");
var import_Icon = require("./Icon");
function Root({
  id,
  children,
  modal = false
}) {
  const [open, onOpenChange] = (0, import_useMenuIsOpen.useMenuIsOpen)(id);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DropdownMenu.Root, { open, dir: "ltr", modal, onOpenChange, children });
}
function Trigger({
  children,
  "data-testid": testId
}) {
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    DropdownMenu.Trigger,
    {
      dir: "ltr",
      "data-testid": testId,
      asChild: true,
      onTouchEnd: (e) => (0, import_editor.preventDefault)(e),
      children
    }
  );
}
function Content({
  side = "bottom",
  align = "start",
  sideOffset = 8,
  alignOffset = 8,
  children
}) {
  const container = (0, import_editor.useContainer)();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DropdownMenu.Portal, { dir: "ltr", container, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    DropdownMenu.Content,
    {
      className: "tlui-menu",
      align,
      sideOffset,
      side,
      alignOffset,
      collisionPadding: 4,
      children
    }
  ) });
}
function Sub({ id, children }) {
  const [open, onOpenChange] = (0, import_useMenuIsOpen.useMenuIsOpen)(id);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DropdownMenu.Sub, { open, onOpenChange, children });
}
function SubTrigger({
  label,
  "data-testid": testId,
  "data-direction": dataDirection
}) {
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DropdownMenu.SubTrigger, { dir: "ltr", "data-direction": dataDirection, "data-testid": testId, asChild: true, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_Button.Button,
    {
      className: "tlui-menu__button tlui-menu__submenu__trigger",
      label,
      icon: "chevron-right"
    }
  ) });
}
function SubContent({
  alignOffset = 0,
  sideOffset = 5,
  children
}) {
  const container = (0, import_editor.useContainer)();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DropdownMenu.Portal, { container, dir: "ltr", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    DropdownMenu.SubContent,
    {
      className: "tlui-menu tlui-menu__submenu__content",
      alignOffset,
      sideOffset,
      collisionPadding: 4,
      children
    }
  ) });
}
function Group({
  children,
  size = "medium"
}) {
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DropdownMenu.Group, { dir: "ltr", className: "tlui-menu__group", "data-size": size, children });
}
function Indicator() {
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DropdownMenu.ItemIndicator, { dir: "ltr", asChild: true, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Icon.Icon, { icon: "check" }) });
}
function Item({ noClose, ...props }) {
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    DropdownMenu.Item,
    {
      dir: "ltr",
      asChild: true,
      onClick: noClose || props.isChecked !== void 0 ? import_editor.preventDefault : void 0,
      children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Button.Button, { className: "tlui-menu__button", ...props })
    }
  );
}
function CheckboxItem({ children, onSelect, ...rest }) {
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
    DropdownMenu.CheckboxItem,
    {
      dir: "ltr",
      className: "tlui-button tlui-menu__button tlui-menu__checkbox-item",
      onSelect: (e) => {
        onSelect?.(e);
        (0, import_editor.preventDefault)(e);
      },
      ...rest,
      children: [
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          "div",
          {
            className: "tlui-menu__checkbox-item__check",
            style: {
              transformOrigin: "75% center",
              transform: `scale(${rest.checked ? 1 : 0.5})`,
              opacity: rest.checked ? 1 : 0.5
            },
            children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Icon.Icon, { small: true, icon: rest.checked ? "check" : "checkbox-empty" })
          }
        ),
        children
      ]
    }
  );
}
function RadioItem({ children, onSelect, ...rest }) {
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
    DropdownMenu.CheckboxItem,
    {
      dir: "ltr",
      className: "tlui-button tlui-menu__button tlui-menu__checkbox-item",
      onSelect: (e) => {
        onSelect?.(e);
        (0, import_editor.preventDefault)(e);
      },
      ...rest,
      children: [
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DropdownMenu.ItemIndicator, { dir: "ltr", className: "tlui-menu__checkbox-item__check", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Icon.Icon, { icon: "check" }) }),
        children
      ]
    }
  );
}
//# sourceMappingURL=DropdownMenu.js.map
