import { jsx } from "react/jsx-runtime";
import { track, useEditor } from "@tldraw/editor";
import { useActions } from "../hooks/useActions.mjs";
import { Button } from "./primitives/Button.mjs";
const StopFollowing = track(function ExitPenMode() {
  const editor = useEditor();
  const actions = useActions();
  if (!editor.instanceState.followingUserId) {
    return null;
  }
  const action = actions["stop-following"];
  return /* @__PURE__ */ jsx(
    Button,
    {
      label: action.label,
      iconLeft: action.icon,
      onClick: () => action.onSelect("people-menu")
    }
  );
});
export {
  StopFollowing
};
//# sourceMappingURL=StopFollowing.mjs.map
