import { useEditor, useValue } from "@tldraw/editor";
function useShowAutoSizeToggle() {
  const editor = useEditor();
  return useValue(
    "showAutoSizeToggle",
    () => {
      const { selectedShapes } = editor;
      return selectedShapes.length === 1 && editor.isShapeOfType(selectedShapes[0], "text") && selectedShapes[0].props.autoSize === false;
    },
    [editor]
  );
}
export {
  useShowAutoSizeToggle
};
//# sourceMappingURL=useShowAutoSizeToggle.mjs.map
