"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ActionsMenu_exports = {};
__export(ActionsMenu_exports, {
  ActionsMenu: () => ActionsMenu
});
module.exports = __toCommonJS(ActionsMenu_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var PopoverPrimitive = __toESM(require("@radix-ui/react-popover"));
var import_editor = require("@tldraw/editor");
var import_react = require("react");
var import_useActionsMenuSchema = require("../hooks/useActionsMenuSchema");
var import_useReadonly = require("../hooks/useReadonly");
var import_useTranslation = require("../hooks/useTranslation/useTranslation");
var import_Button = require("./primitives/Button");
var import_Popover = require("./primitives/Popover");
var import_shared = require("./primitives/shared");
const ActionsMenu = (0, import_react.memo)(function ActionsMenu2() {
  const msg = (0, import_useTranslation.useTranslation)();
  const container = (0, import_editor.useContainer)();
  const menuSchema = (0, import_useActionsMenuSchema.useActionsMenuSchema)();
  const isReadonly = (0, import_useReadonly.useReadonly)();
  function getActionMenuItem(item) {
    if (isReadonly && !item.readonlyOk)
      return null;
    switch (item.type) {
      case "item": {
        const { id, icon, label, kbd, onSelect } = item.actionItem;
        return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          import_Button.Button,
          {
            className: "tlui-button-grid__button",
            "data-testid": `menu-item.${item.id}`,
            icon,
            title: label ? kbd ? `${msg(label)} ${(0, import_shared.kbdStr)(kbd)}` : `${msg(label)}` : kbd ? `${(0, import_shared.kbdStr)(kbd)}` : "",
            onClick: () => onSelect("actions-menu"),
            disabled: item.disabled
          },
          id
        );
      }
    }
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_Popover.Popover, { id: "actions menu", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Popover.PopoverTrigger, { children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_Button.Button,
      {
        className: "tlui-menu__trigger",
        "data-testid": "main.action-menu",
        icon: "dots-vertical",
        title: msg("actions-menu.title"),
        smallIcon: true
      }
    ) }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(PopoverPrimitive.Portal, { dir: "ltr", container, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      PopoverPrimitive.Content,
      {
        className: "tlui-popover__content",
        side: "bottom",
        dir: "ltr",
        sideOffset: 6,
        children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tlui-actions-menu tlui-button-grid__four", children: menuSchema.map(getActionMenuItem) })
      }
    ) })
  ] });
});
//# sourceMappingURL=ActionsMenu.js.map
