"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var HTMLCanvas_exports = {};
__export(HTMLCanvas_exports, {
  HTMLCanvas: () => HTMLCanvas
});
module.exports = __toCommonJS(HTMLCanvas_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var React = __toESM(require("react"));
const HTMLCanvas = (0, import_editor.track)(function HTMLCanvas2() {
  const editor = (0, import_editor.useEditor)();
  const rCanvas = React.useRef(null);
  const camera = editor.camera;
  const shapes = editor.currentPageShapes;
  if (rCanvas.current) {
    const cvs = rCanvas.current;
    const ctx = cvs.getContext("2d");
    ctx.resetTransform();
    ctx.clearRect(0, 0, cvs.width, cvs.height);
    const path = new Path2D();
    ctx.translate(camera.x, camera.y);
    for (const shape of shapes) {
      const bounds = editor.getShapePageBounds(shape);
      path.rect(bounds.minX, bounds.minY, bounds.width, bounds.height);
    }
    ctx.fillStyle = "#cccccc";
    ctx.fill(path);
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    "canvas",
    {
      ref: rCanvas,
      width: editor.viewportScreenBounds.width,
      height: editor.viewportScreenBounds.height,
      style: { width: "100%", height: "100%" }
    }
  );
});
//# sourceMappingURL=HTMLCanvas.js.map
