"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Menu_exports = {};
__export(Menu_exports, {
  Menu: () => Menu
});
module.exports = __toCommonJS(Menu_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var React = __toESM(require("react"));
var import_useBreakpoint = require("../hooks/useBreakpoint");
var import_useMenuSchema = require("../hooks/useMenuSchema");
var import_useReadonly = require("../hooks/useReadonly");
var import_useTranslation = require("../hooks/useTranslation/useTranslation");
var import_LanguageMenu = require("./LanguageMenu");
var import_Button = require("./primitives/Button");
var M = __toESM(require("./primitives/DropdownMenu"));
var import_Kbd = require("./primitives/Kbd");
const Menu = React.memo(function Menu2() {
  const msg = (0, import_useTranslation.useTranslation)();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(M.Root, { id: "main menu", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(M.Trigger, { children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_Button.Button,
      {
        className: "tlui-menu__trigger",
        "data-testid": "main.menu",
        title: msg("menu.title"),
        icon: "menu"
      }
    ) }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(M.Content, { alignOffset: 0, sideOffset: 6, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(MenuContent, {}) })
  ] });
});
function MenuContent() {
  const editor = (0, import_editor.useEditor)();
  const msg = (0, import_useTranslation.useTranslation)();
  const menuSchema = (0, import_useMenuSchema.useMenuSchema)();
  const breakpoint = (0, import_useBreakpoint.useBreakpoint)();
  const isReadonly = (0, import_useReadonly.useReadonly)();
  function getMenuItem(editor2, item, parent, depth) {
    switch (item.type) {
      case "custom": {
        if (isReadonly && !item.readonlyOk)
          return null;
        if (item.id === "LANGUAGE_MENU") {
          return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_LanguageMenu.LanguageMenu, {}, "item");
        }
        return null;
      }
      case "group": {
        if (isReadonly && !item.readonlyOk)
          return null;
        return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          M.Group,
          {
            size: depth <= 1 ? "medium" : breakpoint < 3 || parent?.type === "submenu" && depth > 2 ? "tiny" : "medium",
            children: item.children.map((child) => getMenuItem(editor2, child, item, depth + 1))
          },
          item.id
        );
      }
      case "submenu": {
        if (isReadonly && !item.readonlyOk)
          return null;
        return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(M.Sub, { id: `main menu ${parent ? parent.id + " " : ""}${item.id}`, children: [
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)(M.SubTrigger, { label: item.label, "data-testid": `menu-item.${item.id}` }),
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)(M.SubContent, { sideOffset: -4, alignOffset: -1, children: item.children.map((child) => getMenuItem(editor2, child, item, depth + 1)) })
        ] }, item.id);
      }
      case "item": {
        if (isReadonly && !item.readonlyOk)
          return null;
        const { id, checkbox, menuLabel, label, onSelect, kbd } = item.actionItem;
        const labelToUse = menuLabel ?? label;
        const labelStr = labelToUse ? msg(labelToUse) : void 0;
        if (checkbox) {
          return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
            M.CheckboxItem,
            {
              onSelect: () => onSelect("menu"),
              title: labelStr ? labelStr : "",
              checked: item.checked,
              disabled: item.disabled,
              children: [
                labelStr && /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { children: labelStr }),
                kbd && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Kbd.Kbd, { children: kbd })
              ]
            },
            id
          );
        }
        return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          M.Item,
          {
            "data-testid": `menu-item.${item.id}`,
            kbd,
            label: labelToUse,
            onClick: () => onSelect("menu"),
            disabled: item.disabled
          },
          id
        );
      }
    }
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_jsx_runtime.Fragment, { children: menuSchema.map((item) => getMenuItem(editor, item, null, 0)) });
}
//# sourceMappingURL=Menu.js.map
