"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var NavigationZone_exports = {};
__export(NavigationZone_exports, {
  NavigationZone: () => NavigationZone
});
module.exports = __toCommonJS(NavigationZone_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_react = require("react");
var import_useActions = require("../../hooks/useActions");
var import_useBreakpoint = require("../../hooks/useBreakpoint");
var import_useLocalStorageState = require("../../hooks/useLocalStorageState");
var import_useTranslation = require("../../hooks/useTranslation/useTranslation");
var import_Button = require("../primitives/Button");
var import_shared = require("../primitives/shared");
var import_Minimap = require("./Minimap");
var import_ZoomMenu = require("./ZoomMenu");
const NavigationZone = (0, import_react.memo)(function NavigationZone2() {
  const actions = (0, import_useActions.useActions)();
  const msg = (0, import_useTranslation.useTranslation)();
  const breakpoint = (0, import_useBreakpoint.useBreakpoint)();
  const [collapsed, setCollapsed] = (0, import_useLocalStorageState.useLocalStorageState)("minimap", true);
  const toggleMinimap = (0, import_react.useCallback)(() => {
    setCollapsed((s) => !s);
  }, [setCollapsed]);
  if (breakpoint < 4) {
    return null;
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "tlui-navigation-zone", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tlui-navigation-zone__controls", children: breakpoint < 6 ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_ZoomMenu.ZoomMenu, {}) : collapsed ? /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_jsx_runtime.Fragment, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_ZoomMenu.ZoomMenu, {}),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        import_Button.Button,
        {
          title: msg("navigation-zone.toggle-minimap"),
          className: "tlui-navigation-zone__toggle",
          "data-testid": "minimap.toggle",
          onClick: toggleMinimap,
          icon: collapsed ? "chevrons-ne" : "chevrons-sw"
        }
      )
    ] }) : /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_jsx_runtime.Fragment, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        import_Button.Button,
        {
          icon: "minus",
          "data-testid": "minimap.zoom-out",
          title: `${msg(actions["zoom-out"].label)} ${(0, import_shared.kbdStr)(actions["zoom-out"].kbd)}`,
          onClick: () => actions["zoom-out"].onSelect("navigation-zone")
        }
      ),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_ZoomMenu.ZoomMenu, {}),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        import_Button.Button,
        {
          icon: "plus",
          "data-testid": "minimap.zoom-in",
          title: `${msg(actions["zoom-in"].label)} ${(0, import_shared.kbdStr)(actions["zoom-in"].kbd)}`,
          onClick: () => actions["zoom-in"].onSelect("navigation-zone")
        }
      ),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        import_Button.Button,
        {
          title: msg("navigation-zone.toggle-minimap"),
          className: "tlui-navigation-zone__toggle",
          onClick: toggleMinimap,
          icon: collapsed ? "chevrons-ne" : "chevrons-sw"
        }
      )
    ] }) }),
    breakpoint >= 6 && !collapsed && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_Minimap.Minimap,
      {
        viewportFill: "--color-muted-1",
        selectFill: "--color-selected",
        shapeFill: "--color-text-3"
      }
    )
  ] });
});
//# sourceMappingURL=NavigationZone.js.map
