"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var ZoomMenu_exports = {};
__export(ZoomMenu_exports, {
  ZoomMenu: () => ZoomMenu
});
module.exports = __toCommonJS(ZoomMenu_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var React = __toESM(require("react"));
var import_useActions = require("../../hooks/useActions");
var import_useBreakpoint = require("../../hooks/useBreakpoint");
var import_useTranslation = require("../../hooks/useTranslation/useTranslation");
var import_Button = require("../primitives/Button");
var M = __toESM(require("../primitives/DropdownMenu"));
const ZoomMenu = (0, import_editor.track)(function ZoomMenu2() {
  const editor = (0, import_editor.useEditor)();
  const msg = (0, import_useTranslation.useTranslation)();
  const breakpoint = (0, import_useBreakpoint.useBreakpoint)();
  const zoom = editor.zoomLevel;
  const hasShapes = editor.currentPageShapeIds.size > 0;
  const hasSelected = editor.selectedShapeIds.length > 0;
  const isZoomedTo100 = editor.zoomLevel === 1;
  const handleDoubleClick = React.useCallback(() => {
    editor.resetZoom(editor.viewportScreenCenter, { duration: import_editor.ANIMATION_MEDIUM_MS });
  }, [editor]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(M.Root, { id: "zoom", children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(M.Trigger, { children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_Button.Button,
      {
        title: `${msg("navigation-zone.zoom")}`,
        "data-testid": "minimap.zoom-menu",
        className: breakpoint < 5 ? "tlui-zoom-menu__button" : "tlui-zoom-menu__button__pct",
        onDoubleClick: handleDoubleClick,
        icon: breakpoint < 4 ? "zoom-in" : void 0,
        children: breakpoint < 4 ? null : /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("span", { style: { flexGrow: 0, textAlign: "center" }, children: [
          Math.floor(zoom * 100),
          "%"
        ] })
      }
    ) }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(M.Content, { side: "top", align: "start", alignOffset: 0, children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(M.Group, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(ZoomMenuItem, { action: "zoom-in", "data-testid": "minimap.zoom-menu.zoom-in", noClose: true }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(ZoomMenuItem, { action: "zoom-out", "data-testid": "minimap.zoom-menu.zoom-out", noClose: true }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        ZoomMenuItem,
        {
          action: "zoom-to-100",
          "data-testid": "minimap.zoom-menu.zoom-to-100",
          noClose: true,
          disabled: isZoomedTo100
        }
      ),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        ZoomMenuItem,
        {
          action: "zoom-to-fit",
          disabled: !hasShapes,
          "data-testid": "minimap.zoom-menu.zoom-to-fit",
          noClose: true
        }
      ),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        ZoomMenuItem,
        {
          action: "zoom-to-selection",
          disabled: !hasSelected,
          "data-testid": "minimap.zoom-menu.zoom-to-selection",
          noClose: true
        }
      )
    ] }) })
  ] });
});
function ZoomMenuItem(props) {
  const { action, disabled = false, noClose = false } = props;
  const actions = (0, import_useActions.useActions)();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    M.Item,
    {
      label: actions[action].label,
      kbd: actions[action].kbd,
      "data-testid": props["data-testid"],
      onClick: () => actions[action].onSelect("zoom-menu"),
      noClose,
      disabled
    }
  );
}
//# sourceMappingURL=ZoomMenu.js.map
