"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var PageItemSubmenu_exports = {};
__export(PageItemSubmenu_exports, {
  PageItemSubmenu: () => PageItemSubmenu
});
module.exports = __toCommonJS(PageItemSubmenu_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var DropdownMenu = __toESM(require("@radix-ui/react-dropdown-menu"));
var import_editor = require("@tldraw/editor");
var import_react = require("react");
var import_useTranslation = require("../../hooks/useTranslation/useTranslation");
var import_Button = require("../primitives/Button");
var M = __toESM(require("../primitives/DropdownMenu"));
var import_edit_pages_shared = require("./edit-pages-shared");
const PageItemSubmenu = (0, import_editor.track)(function PageItemSubmenu2({
  index,
  listSize,
  item,
  onRename
}) {
  const editor = (0, import_editor.useEditor)();
  const msg = (0, import_useTranslation.useTranslation)();
  const pages = editor.pages;
  const onDuplicate = (0, import_react.useCallback)(() => {
    editor.mark("creating page");
    const newId = import_editor.PageRecordType.createId();
    editor.duplicatePage(item.id, newId);
  }, [editor, item]);
  const onMoveUp = (0, import_react.useCallback)(() => {
    (0, import_edit_pages_shared.onMovePage)(editor, item.id, index, index - 1);
  }, [editor, item, index]);
  const onMoveDown = (0, import_react.useCallback)(() => {
    (0, import_edit_pages_shared.onMovePage)(editor, item.id, index, index + 1);
  }, [editor, item, index]);
  const onDelete = (0, import_react.useCallback)(() => {
    editor.mark("deleting page");
    editor.deletePage(item.id);
  }, [editor, item]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(M.Root, { id: `page item submenu ${index}`, children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(M.Trigger, { children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Button.Button, { title: msg("page-menu.submenu.title"), icon: "dots-vertical" }) }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(M.Content, { alignOffset: 0, children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(M.Group, { children: [
        onRename && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DropdownMenu.Item, { dir: "ltr", onSelect: onRename, asChild: true, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Button.Button, { className: "tlui-menu__button", label: "page-menu.submenu.rename" }) }),
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          DropdownMenu.Item,
          {
            dir: "ltr",
            onSelect: onDuplicate,
            disabled: pages.length >= import_editor.MAX_PAGES,
            asChild: true,
            children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Button.Button, { className: "tlui-menu__button", label: "page-menu.submenu.duplicate-page" })
          }
        ),
        index > 0 && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DropdownMenu.Item, { dir: "ltr", onSelect: onMoveUp, asChild: true, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Button.Button, { className: "tlui-menu__button", label: "page-menu.submenu.move-up" }) }),
        index < listSize - 1 && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DropdownMenu.Item, { dir: "ltr", onSelect: onMoveDown, asChild: true, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Button.Button, { className: "tlui-menu__button", label: "page-menu.submenu.move-down" }) })
      ] }),
      listSize > 1 && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(M.Group, { children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(DropdownMenu.Item, { dir: "ltr", onSelect: onDelete, asChild: true, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Button.Button, { className: "tlui-menu__button", label: "page-menu.submenu.delete" }) }) })
    ] })
  ] });
});
//# sourceMappingURL=PageItemSubmenu.js.map
