"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var menuHelpers_exports = {};
__export(menuHelpers_exports, {
  compactMenuItems: () => compactMenuItems,
  findMenuItem: () => findMenuItem,
  menuCustom: () => menuCustom,
  menuGroup: () => menuGroup,
  menuItem: () => menuItem,
  menuSubmenu: () => menuSubmenu,
  showMenuPaste: () => showMenuPaste,
  useAllowGroup: () => useAllowGroup,
  useAllowUngroup: () => useAllowUngroup,
  useThreeStackableItems: () => useThreeStackableItems
});
module.exports = __toCommonJS(menuHelpers_exports);
var import_editor = require("@tldraw/editor");
function compactMenuItems(arr) {
  return arr.filter((i) => i !== void 0 && i !== null && i !== false);
}
function menuGroup(id, ...children) {
  const childItems = compactMenuItems(children);
  if (childItems.length === 0)
    return null;
  return {
    id,
    type: "group",
    checkbox: childItems.every((child) => child.type === "item" && child.actionItem.checkbox),
    disabled: childItems.every((child) => child.disabled),
    readonlyOk: childItems.some((child) => child.readonlyOk),
    children: childItems
  };
}
function menuSubmenu(id, label, ...children) {
  const childItems = compactMenuItems(children);
  if (childItems.length === 0)
    return null;
  return {
    id,
    type: "submenu",
    label,
    children: childItems,
    disabled: childItems.every((child) => child.disabled),
    readonlyOk: childItems.some((child) => child.readonlyOk)
  };
}
function menuCustom(id, opts = {}) {
  const { readonlyOk = true, disabled = false } = opts;
  return {
    id,
    type: "custom",
    disabled,
    readonlyOk
  };
}
function menuItem(actionItem, opts = {}) {
  if (!actionItem) {
    throw Error("No action item provided to menuItem");
  }
  if (!actionItem.label) {
    throw Error("Trying to create menu item for action item that doesn't have a label");
  }
  const { checked = false, disabled = false } = opts;
  return {
    id: actionItem.id,
    type: "item",
    actionItem,
    disabled,
    checked,
    readonlyOk: actionItem.readonlyOk
  };
}
function shapesWithUnboundArrows(editor) {
  const { selectedShapeIds } = editor;
  const selectedShapes = selectedShapeIds.map((id) => {
    return editor.getShape(id);
  });
  return selectedShapes.filter((shape) => {
    if (!shape)
      return false;
    if (editor.isShapeOfType(shape, "arrow") && shape.props.start.type === "binding") {
      return false;
    }
    if (editor.isShapeOfType(shape, "arrow") && shape.props.end.type === "binding") {
      return false;
    }
    return true;
  });
}
const useThreeStackableItems = () => {
  const editor = (0, import_editor.useEditor)();
  return (0, import_editor.useValue)("threeStackableItems", () => shapesWithUnboundArrows(editor).length > 2, [editor]);
};
const useAllowGroup = () => {
  const editor = (0, import_editor.useEditor)();
  return (0, import_editor.useValue)("allowGroup", () => shapesWithUnboundArrows(editor).length > 1, [editor]);
};
const useAllowUngroup = () => {
  const editor = (0, import_editor.useEditor)();
  return (0, import_editor.useValue)(
    "allowUngroup",
    () => editor.selectedShapeIds.some((id) => editor.getShape(id)?.type === "group"),
    []
  );
};
function findMenuItem(menu, path) {
  const item = _findMenuItem(menu, path);
  (0, import_editor.assert)(item, `Menu item ${path.join(" > ")} not found`);
  return item;
}
function _findMenuItem(menu, path) {
  const [next, ...rest] = path;
  if (!next)
    return null;
  const item = menu.find((item2) => item2.id === next);
  if (!item)
    return null;
  switch (item.type) {
    case "group":
    case "submenu":
      return rest.length === 0 ? item : _findMenuItem(item.children, rest);
    case "item":
    case "custom":
      return rest.length === 0 ? item : null;
    default:
      (0, import_editor.exhaustiveSwitchError)(item, "type");
  }
}
const showMenuPaste = typeof window !== "undefined" && "navigator" in window && Boolean(navigator.clipboard) && Boolean(navigator.clipboard.read);
//# sourceMappingURL=menuHelpers.js.map
