"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var useActionsMenuSchema_exports = {};
__export(useActionsMenuSchema_exports, {
  ActionsMenuSchemaContext: () => ActionsMenuSchemaContext,
  ActionsMenuSchemaProvider: () => ActionsMenuSchemaProvider,
  useActionsMenuSchema: () => useActionsMenuSchema
});
module.exports = __toCommonJS(useActionsMenuSchema_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_react = __toESM(require("react"));
var import_menuHelpers = require("./menuHelpers");
var import_useActions = require("./useActions");
var import_useBreakpoint = require("./useBreakpoint");
var import_useHasLinkShapeSelected = require("./useHasLinkShapeSelected");
const ActionsMenuSchemaContext = import_react.default.createContext({});
const ActionsMenuSchemaProvider = (0, import_editor.track)(function ActionsMenuSchemaProvider2({
  overrides,
  children
}) {
  const editor = (0, import_editor.useEditor)();
  const actions = (0, import_useActions.useActions)();
  const selectedCount = editor.selectedShapeIds.length;
  const oneSelected = selectedCount > 0;
  const twoSelected = selectedCount > 1;
  const threeSelected = selectedCount > 2;
  const threeStackableItems = (0, import_menuHelpers.useThreeStackableItems)();
  const allowGroup = (0, import_menuHelpers.useAllowGroup)();
  const allowUngroup = (0, import_menuHelpers.useAllowUngroup)();
  const showEditLink = (0, import_useHasLinkShapeSelected.useHasLinkShapeSelected)();
  const breakpoint = (0, import_useBreakpoint.useBreakpoint)();
  const isZoomedTo100 = editor.zoomLevel === 1;
  const actionTLUiMenuSchema = (0, import_react.useMemo)(() => {
    const results = [
      (0, import_menuHelpers.menuItem)(actions["align-left"], { disabled: !twoSelected }),
      (0, import_menuHelpers.menuItem)(actions["align-center-horizontal"], { disabled: !twoSelected }),
      (0, import_menuHelpers.menuItem)(actions["align-right"], { disabled: !twoSelected }),
      (0, import_menuHelpers.menuItem)(actions["stretch-horizontal"], { disabled: !twoSelected }),
      (0, import_menuHelpers.menuItem)(actions["align-top"], { disabled: !twoSelected }),
      (0, import_menuHelpers.menuItem)(actions["align-center-vertical"], { disabled: !twoSelected }),
      (0, import_menuHelpers.menuItem)(actions["align-bottom"], { disabled: !twoSelected }),
      (0, import_menuHelpers.menuItem)(actions["stretch-vertical"], { disabled: !twoSelected }),
      (0, import_menuHelpers.menuItem)(actions["distribute-horizontal"], { disabled: !threeSelected }),
      (0, import_menuHelpers.menuItem)(actions["distribute-vertical"], { disabled: !threeSelected }),
      (0, import_menuHelpers.menuItem)(actions["stack-horizontal"], { disabled: !threeStackableItems }),
      (0, import_menuHelpers.menuItem)(actions["stack-vertical"], { disabled: !threeStackableItems }),
      (0, import_menuHelpers.menuItem)(actions["send-to-back"], { disabled: !oneSelected }),
      (0, import_menuHelpers.menuItem)(actions["send-backward"], { disabled: !oneSelected }),
      (0, import_menuHelpers.menuItem)(actions["bring-forward"], { disabled: !oneSelected }),
      (0, import_menuHelpers.menuItem)(actions["bring-to-front"], { disabled: !oneSelected }),
      breakpoint < 5 ? (0, import_menuHelpers.menuItem)(actions["zoom-to-100"], { disabled: !!isZoomedTo100 }) : (0, import_menuHelpers.menuItem)(actions["rotate-ccw"], { disabled: !oneSelected }),
      (0, import_menuHelpers.menuItem)(actions["rotate-cw"], { disabled: !oneSelected }),
      (0, import_menuHelpers.menuItem)(actions["edit-link"], { disabled: !showEditLink }),
      allowGroup ? (0, import_menuHelpers.menuItem)(actions["group"], { disabled: !twoSelected }) : allowUngroup ? (0, import_menuHelpers.menuItem)(actions["ungroup"]) : (0, import_menuHelpers.menuItem)(actions["group"], { disabled: !twoSelected })
    ];
    if (overrides) {
      return overrides(editor, results, { actions, oneSelected, twoSelected, threeSelected });
    }
    return results;
  }, [
    editor,
    isZoomedTo100,
    allowGroup,
    overrides,
    actions,
    oneSelected,
    twoSelected,
    threeSelected,
    threeStackableItems,
    allowUngroup,
    showEditLink,
    breakpoint
  ]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(ActionsMenuSchemaContext.Provider, { value: actionTLUiMenuSchema, children });
});
function useActionsMenuSchema() {
  const ctx = import_react.default.useContext(ActionsMenuSchemaContext);
  if (!ctx) {
    throw new Error("useActionsMenuSchema must be used inside of a ActionsMenuSchemaProvider.");
  }
  return ctx;
}
//# sourceMappingURL=useActionsMenuSchema.js.map
