"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var useBreakpoint_exports = {};
__export(useBreakpoint_exports, {
  BreakPointProvider: () => BreakPointProvider,
  useBreakpoint: () => useBreakpoint
});
module.exports = __toCommonJS(useBreakpoint_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_react = __toESM(require("react"));
var import_constants = require("../constants");
const BreakpointContext = import_react.default.createContext(0);
function BreakPointProvider({ children }) {
  const editor = (0, import_editor.useEditor)();
  const breakpoint = (0, import_editor.useValue)(
    "breakpoint",
    () => {
      const { width } = editor.viewportScreenBounds;
      const breakpoints = import_constants.PORTRAIT_BREAKPOINTS;
      for (let i = 0; i < breakpoints.length - 1; i++) {
        if (width > breakpoints[i] && width <= breakpoints[i + 1]) {
          return i;
        }
      }
      return breakpoints.length;
    },
    [editor]
  );
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(BreakpointContext.Provider, { value: breakpoint, children });
}
function useBreakpoint() {
  let breakpoint = (0, import_react.useContext)(BreakpointContext);
  const layoutQuery = new URL(window.location.href).searchParams.get("layout");
  if (layoutQuery === "desktop") {
    breakpoint = 7;
  } else if (layoutQuery === "mobile") {
    breakpoint = 1;
  }
  return breakpoint;
}
//# sourceMappingURL=useBreakpoint.js.map
