"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var useContextMenuSchema_exports = {};
__export(useContextMenuSchema_exports, {
  TLUiContextMenuSchemaContext: () => TLUiContextMenuSchemaContext,
  TLUiContextMenuSchemaProvider: () => TLUiContextMenuSchemaProvider,
  useContextMenuSchema: () => useContextMenuSchema
});
module.exports = __toCommonJS(useContextMenuSchema_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_react = __toESM(require("react"));
var import_menuHelpers = require("./menuHelpers");
var import_useActions = require("./useActions");
var import_useHasLinkShapeSelected = require("./useHasLinkShapeSelected");
var import_useOnlyFlippableShape = require("./useOnlyFlippableShape");
var import_useShowAutoSizeToggle = require("./useShowAutoSizeToggle");
const TLUiContextMenuSchemaContext = import_react.default.createContext(
  {}
);
const TLUiContextMenuSchemaProvider = (0, import_editor.track)(function TLUiContextMenuSchemaProvider2({
  overrides,
  children
}) {
  const editor = (0, import_editor.useEditor)();
  const actions = (0, import_useActions.useActions)();
  const showAutoSizeToggle = (0, import_useShowAutoSizeToggle.useShowAutoSizeToggle)();
  const onlyFlippableShapeSelected = (0, import_useOnlyFlippableShape.useOnlyFlippableShape)();
  const selectedCount = editor.selectedShapeIds.length;
  const oneSelected = selectedCount > 0;
  const twoSelected = selectedCount > 1;
  const threeSelected = selectedCount > 2;
  const threeStackableItems = (0, import_menuHelpers.useThreeStackableItems)();
  const atLeastOneShapeOnPage = (0, import_editor.useValue)(
    "atLeastOneShapeOnPage",
    () => editor.currentPageShapeIds.size > 0,
    []
  );
  const isTransparentBg = (0, import_editor.useValue)(
    "isTransparentBg",
    () => editor.instanceState.exportBackground,
    []
  );
  const allowGroup = (0, import_menuHelpers.useAllowGroup)();
  const allowUngroup = (0, import_menuHelpers.useAllowUngroup)();
  const hasClipboardWrite = Boolean(window.navigator.clipboard?.write);
  const showEditLink = (0, import_useHasLinkShapeSelected.useHasLinkShapeSelected)();
  const { onlySelectedShape } = editor;
  const isShapeLocked = onlySelectedShape && editor.isShapeOrAncestorLocked(onlySelectedShape);
  const contextTLUiMenuSchema = (0, import_react.useMemo)(() => {
    let contextTLUiMenuSchema2 = (0, import_menuHelpers.compactMenuItems)([
      (0, import_menuHelpers.menuGroup)(
        "selection",
        showAutoSizeToggle && (0, import_menuHelpers.menuItem)(actions["toggle-auto-size"]),
        showEditLink && !isShapeLocked && (0, import_menuHelpers.menuItem)(actions["edit-link"]),
        oneSelected && !isShapeLocked && (0, import_menuHelpers.menuItem)(actions["duplicate"]),
        allowGroup && !isShapeLocked && (0, import_menuHelpers.menuItem)(actions["group"]),
        allowUngroup && !isShapeLocked && (0, import_menuHelpers.menuItem)(actions["ungroup"]),
        oneSelected && (0, import_menuHelpers.menuItem)(actions["toggle-lock"])
      ),
      (0, import_menuHelpers.menuGroup)(
        "modify",
        (twoSelected || onlyFlippableShapeSelected) && (0, import_menuHelpers.menuSubmenu)(
          "arrange",
          "context-menu.arrange",
          twoSelected && (0, import_menuHelpers.menuGroup)(
            "align",
            (0, import_menuHelpers.menuItem)(actions["align-left"]),
            (0, import_menuHelpers.menuItem)(actions["align-center-horizontal"]),
            (0, import_menuHelpers.menuItem)(actions["align-right"]),
            (0, import_menuHelpers.menuItem)(actions["align-top"]),
            (0, import_menuHelpers.menuItem)(actions["align-center-vertical"]),
            (0, import_menuHelpers.menuItem)(actions["align-bottom"])
          ),
          threeSelected && (0, import_menuHelpers.menuGroup)(
            "distribute",
            (0, import_menuHelpers.menuItem)(actions["distribute-horizontal"]),
            (0, import_menuHelpers.menuItem)(actions["distribute-vertical"])
          ),
          twoSelected && (0, import_menuHelpers.menuGroup)(
            "stretch",
            (0, import_menuHelpers.menuItem)(actions["stretch-horizontal"]),
            (0, import_menuHelpers.menuItem)(actions["stretch-vertical"])
          ),
          onlyFlippableShapeSelected && !isShapeLocked && (0, import_menuHelpers.menuGroup)(
            "flip",
            (0, import_menuHelpers.menuItem)(actions["flip-horizontal"]),
            (0, import_menuHelpers.menuItem)(actions["flip-vertical"])
          ),
          twoSelected && (0, import_menuHelpers.menuGroup)(
            "order",
            (0, import_menuHelpers.menuItem)(actions["pack"], { disabled: !twoSelected }),
            threeStackableItems && (0, import_menuHelpers.menuItem)(actions["stack-vertical"]),
            threeStackableItems && (0, import_menuHelpers.menuItem)(actions["stack-horizontal"])
          )
        ),
        oneSelected && !isShapeLocked && (0, import_menuHelpers.menuSubmenu)(
          "reorder",
          "context-menu.reorder",
          (0, import_menuHelpers.menuGroup)(
            "reorder",
            (0, import_menuHelpers.menuItem)(actions["bring-to-front"]),
            (0, import_menuHelpers.menuItem)(actions["bring-forward"]),
            (0, import_menuHelpers.menuItem)(actions["send-backward"]),
            (0, import_menuHelpers.menuItem)(actions["send-to-back"])
          )
        ),
        oneSelected && !isShapeLocked && (0, import_menuHelpers.menuCustom)("MOVE_TO_PAGE_MENU", { readonlyOk: false })
      ),
      (0, import_menuHelpers.menuGroup)(
        "clipboard-group",
        oneSelected && !isShapeLocked && (0, import_menuHelpers.menuItem)(actions["cut"]),
        oneSelected && (0, import_menuHelpers.menuItem)(actions["copy"]),
        import_menuHelpers.showMenuPaste && (0, import_menuHelpers.menuItem)(actions["paste"])
      ),
      atLeastOneShapeOnPage && (0, import_menuHelpers.menuGroup)(
        "conversions",
        (0, import_menuHelpers.menuSubmenu)(
          "copy-as",
          "context-menu.copy-as",
          (0, import_menuHelpers.menuGroup)(
            "copy-as-group",
            (0, import_menuHelpers.menuItem)(actions["copy-as-svg"]),
            hasClipboardWrite && (0, import_menuHelpers.menuItem)(actions["copy-as-png"]),
            (0, import_menuHelpers.menuItem)(actions["copy-as-json"])
          ),
          (0, import_menuHelpers.menuGroup)(
            "export-bg",
            (0, import_menuHelpers.menuItem)(actions["toggle-transparent"], { checked: !isTransparentBg })
          )
        ),
        (0, import_menuHelpers.menuSubmenu)(
          "export-as",
          "context-menu.export-as",
          (0, import_menuHelpers.menuGroup)(
            "export-as-group",
            (0, import_menuHelpers.menuItem)(actions["export-as-svg"]),
            (0, import_menuHelpers.menuItem)(actions["export-as-png"]),
            (0, import_menuHelpers.menuItem)(actions["export-as-json"])
          ),
          (0, import_menuHelpers.menuGroup)(
            "export-bg,",
            (0, import_menuHelpers.menuItem)(actions["toggle-transparent"], { checked: !isTransparentBg })
          )
        )
      ),
      atLeastOneShapeOnPage && (0, import_menuHelpers.menuGroup)(
        "set-selection-group",
        (0, import_menuHelpers.menuItem)(actions["select-all"]),
        oneSelected && (0, import_menuHelpers.menuItem)(actions["select-none"])
      ),
      oneSelected && !isShapeLocked && (0, import_menuHelpers.menuGroup)("delete-group", (0, import_menuHelpers.menuItem)(actions["delete"]))
    ]);
    if (overrides) {
      contextTLUiMenuSchema2 = overrides(editor, contextTLUiMenuSchema2, {
        actions,
        oneSelected,
        twoSelected,
        threeSelected,
        showAutoSizeToggle,
        showUngroup: allowUngroup,
        onlyFlippableShapeSelected
      });
    }
    return contextTLUiMenuSchema2;
  }, [
    editor,
    overrides,
    actions,
    oneSelected,
    twoSelected,
    threeSelected,
    showAutoSizeToggle,
    onlyFlippableShapeSelected,
    atLeastOneShapeOnPage,
    threeStackableItems,
    allowGroup,
    allowUngroup,
    hasClipboardWrite,
    showEditLink,
    // oneEmbedSelected,
    // oneEmbeddableBookmarkSelected,
    isTransparentBg,
    isShapeLocked
  ]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(TLUiContextMenuSchemaContext.Provider, { value: contextTLUiMenuSchema, children });
});
function useContextMenuSchema() {
  const ctx = import_react.default.useContext(TLUiContextMenuSchemaContext);
  if (!ctx) {
    throw new Error("useContextMenuSchema must be used inside of a TLUiContextMenuSchemaProvider.");
  }
  return ctx;
}
//# sourceMappingURL=useContextMenuSchema.js.map
