"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var useHelpMenuSchema_exports = {};
__export(useHelpMenuSchema_exports, {
  HelpMenuSchemaContext: () => HelpMenuSchemaContext,
  HelpMenuSchemaProvider: () => HelpMenuSchemaProvider,
  useHelpMenuSchema: () => useHelpMenuSchema
});
module.exports = __toCommonJS(useHelpMenuSchema_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_react = __toESM(require("react"));
var import_KeyboardShortcutsDialog = require("../components/KeyboardShortcutsDialog");
var import_menuHelpers = require("./menuHelpers");
var import_useActions = require("./useActions");
var import_useDialogsProvider = require("./useDialogsProvider");
var import_useLanguages = require("./useTranslation/useLanguages");
const HelpMenuSchemaContext = import_react.default.createContext({});
const HelpMenuSchemaProvider = (0, import_editor.track)(function HelpMenuSchemaProvider2({
  overrides,
  children
}) {
  const editor = (0, import_editor.useEditor)();
  const actions = (0, import_useActions.useActions)();
  const selectedCount = editor.selectedShapeIds.length;
  const oneSelected = selectedCount > 0;
  const twoSelected = selectedCount > 1;
  const threeSelected = selectedCount > 2;
  const { languages, currentLanguage } = (0, import_useLanguages.useLanguages)();
  const { addDialog } = (0, import_useDialogsProvider.useDialogs)();
  const helpTLUiMenuSchema = (0, import_react.useMemo)(() => {
    const helpTLUiMenuSchema2 = (0, import_editor.compact)([
      (0, import_menuHelpers.menuGroup)(
        "top",
        (0, import_menuHelpers.menuCustom)("LANGUAGE_MENU", { readonlyOk: true }),
        (0, import_menuHelpers.menuItem)({
          id: "keyboard-shortcuts",
          label: "help-menu.keyboard-shortcuts",
          readonlyOk: true,
          onSelect() {
            addDialog({ component: import_KeyboardShortcutsDialog.KeyboardShortcutsDialog });
          }
        })
      )
    ]);
    if (overrides) {
      return overrides(editor, helpTLUiMenuSchema2, {
        actions,
        currentLanguage,
        languages,
        oneSelected,
        twoSelected,
        threeSelected
      });
    }
    return helpTLUiMenuSchema2;
  }, [
    editor,
    overrides,
    languages,
    actions,
    oneSelected,
    twoSelected,
    threeSelected,
    currentLanguage,
    addDialog
  ]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(HelpMenuSchemaContext.Provider, { value: helpTLUiMenuSchema, children });
});
function useHelpMenuSchema() {
  const ctx = import_react.default.useContext(HelpMenuSchemaContext);
  if (!ctx) {
    throw new Error("useHelpMenuSchema must be used inside of a helpTLUiMenuSchemaProvider.");
  }
  return ctx;
}
//# sourceMappingURL=useHelpMenuSchema.js.map
