"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var useMenuSchema_exports = {};
__export(useMenuSchema_exports, {
  TLUiMenuSchemaContext: () => TLUiMenuSchemaContext,
  TLUiMenuSchemaProvider: () => TLUiMenuSchemaProvider,
  useMenuSchema: () => useMenuSchema
});
module.exports = __toCommonJS(useMenuSchema_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_react = __toESM(require("react"));
var import_embeds = require("../../utils/embeds");
var import_menuHelpers = require("./menuHelpers");
var import_useActions = require("./useActions");
var import_useBreakpoint = require("./useBreakpoint");
var import_useCanRedo = require("./useCanRedo");
var import_useCanUndo = require("./useCanUndo");
var import_useHasLinkShapeSelected = require("./useHasLinkShapeSelected");
var import_useShowAutoSizeToggle = require("./useShowAutoSizeToggle");
const TLUiMenuSchemaContext = import_react.default.createContext({});
function TLUiMenuSchemaProvider({ overrides, children }) {
  const editor = (0, import_editor.useEditor)();
  const actions = (0, import_useActions.useActions)();
  const breakpoint = (0, import_useBreakpoint.useBreakpoint)();
  const isMobile = breakpoint < 5;
  const isDarkMode = (0, import_editor.useValue)("isDarkMode", () => editor.user.isDarkMode, [editor]);
  const animationSpeed = (0, import_editor.useValue)("animationSpeed", () => editor.user.animationSpeed, [editor]);
  const isGridMode = (0, import_editor.useValue)("isGridMode", () => editor.instanceState.isGridMode, [editor]);
  const isSnapMode = (0, import_editor.useValue)("isSnapMode", () => editor.user.isSnapMode, [editor]);
  const isToolLock = (0, import_editor.useValue)("isToolLock", () => editor.instanceState.isToolLocked, [editor]);
  const isFocusMode = (0, import_editor.useValue)("isFocusMode", () => editor.instanceState.isFocusMode, [editor]);
  const isDebugMode = (0, import_editor.useValue)("isDebugMode", () => editor.instanceState.isDebugMode, [editor]);
  const exportBackground = (0, import_editor.useValue)(
    "exportBackground",
    () => editor.instanceState.exportBackground,
    [editor]
  );
  const emptyPage = (0, import_editor.useValue)("emptyPage", () => editor.currentPageShapeIds.size === 0, [editor]);
  const selectedCount = (0, import_editor.useValue)("selectedCount", () => editor.selectedShapeIds.length, [editor]);
  const noneSelected = selectedCount === 0;
  const oneSelected = selectedCount > 0;
  const twoSelected = selectedCount > 1;
  const threeSelected = selectedCount > 2;
  const hasClipboardWrite = Boolean(window.navigator.clipboard?.write);
  const showEditLink = (0, import_useHasLinkShapeSelected.useHasLinkShapeSelected)();
  const showAutoSizeToggle = (0, import_useShowAutoSizeToggle.useShowAutoSizeToggle)();
  const allowGroup = (0, import_menuHelpers.useAllowGroup)();
  const allowUngroup = (0, import_menuHelpers.useAllowUngroup)();
  const canUndo = (0, import_useCanUndo.useCanUndo)();
  const canRedo = (0, import_useCanRedo.useCanRedo)();
  const isZoomedTo100 = (0, import_editor.useValue)("isZoomedTo100", () => editor.zoomLevel === 1, [editor]);
  const oneEmbedSelected = (0, import_editor.useValue)(
    "oneEmbedSelected",
    () => {
      const { onlySelectedShape } = editor;
      if (!onlySelectedShape)
        return false;
      return !!(editor.isShapeOfType(onlySelectedShape, "embed") && onlySelectedShape.props.url && !editor.isShapeOrAncestorLocked(onlySelectedShape));
    },
    []
  );
  const oneEmbeddableBookmarkSelected = (0, import_editor.useValue)(
    "oneEmbeddableBookmarkSelected",
    () => {
      const { onlySelectedShape } = editor;
      if (!onlySelectedShape)
        return false;
      return !!(editor.isShapeOfType(onlySelectedShape, "bookmark") && onlySelectedShape.props.url && (0, import_embeds.getEmbedInfo)(onlySelectedShape.props.url) && !editor.isShapeOrAncestorLocked(onlySelectedShape));
    },
    []
  );
  const menuSchema = (0, import_react.useMemo)(() => {
    const menuSchema2 = (0, import_menuHelpers.compactMenuItems)([
      (0, import_menuHelpers.menuGroup)(
        "menu",
        (0, import_menuHelpers.menuSubmenu)(
          "file",
          "menu.file",
          (0, import_menuHelpers.menuGroup)("print", (0, import_menuHelpers.menuItem)(actions["print"], { disabled: emptyPage }))
        ),
        (0, import_menuHelpers.menuSubmenu)(
          "edit",
          "menu.edit",
          (0, import_menuHelpers.menuGroup)(
            "undo-actions",
            (0, import_menuHelpers.menuItem)(actions["undo"], { disabled: !canUndo }),
            (0, import_menuHelpers.menuItem)(actions["redo"], { disabled: !canRedo })
          ),
          (0, import_menuHelpers.menuGroup)(
            "clipboard-actions",
            (0, import_menuHelpers.menuItem)(actions["cut"], { disabled: noneSelected }),
            (0, import_menuHelpers.menuItem)(actions["copy"], { disabled: noneSelected }),
            (0, import_menuHelpers.menuItem)(actions["paste"], { disabled: !import_menuHelpers.showMenuPaste })
          ),
          (0, import_menuHelpers.menuGroup)(
            "conversions",
            (0, import_menuHelpers.menuSubmenu)(
              "copy-as",
              "menu.copy-as",
              (0, import_menuHelpers.menuGroup)(
                "copy-as-group",
                (0, import_menuHelpers.menuItem)(actions["copy-as-svg"], { disabled: emptyPage }),
                (0, import_menuHelpers.menuItem)(actions["copy-as-png"], { disabled: emptyPage || !hasClipboardWrite }),
                (0, import_menuHelpers.menuItem)(actions["copy-as-json"], { disabled: emptyPage })
              ),
              (0, import_menuHelpers.menuGroup)(
                "export-bg",
                (0, import_menuHelpers.menuItem)(actions["toggle-transparent"], { checked: !exportBackground })
              )
            ),
            (0, import_menuHelpers.menuSubmenu)(
              "export-as",
              "menu.export-as",
              (0, import_menuHelpers.menuGroup)(
                "export-as-group",
                (0, import_menuHelpers.menuItem)(actions["export-as-svg"], { disabled: emptyPage }),
                (0, import_menuHelpers.menuItem)(actions["export-as-png"], { disabled: emptyPage }),
                (0, import_menuHelpers.menuItem)(actions["export-as-json"], { disabled: emptyPage })
              ),
              (0, import_menuHelpers.menuGroup)(
                "export-bg",
                (0, import_menuHelpers.menuItem)(actions["toggle-transparent"], { checked: !exportBackground })
              )
            )
          ),
          (0, import_menuHelpers.menuGroup)(
            "set-selection-group",
            (0, import_menuHelpers.menuItem)(actions["select-all"], { disabled: emptyPage }),
            (0, import_menuHelpers.menuItem)(actions["select-none"], { disabled: !oneSelected })
          ),
          (0, import_menuHelpers.menuGroup)(
            "selection",
            showAutoSizeToggle && (0, import_menuHelpers.menuItem)(actions["toggle-auto-size"]),
            showEditLink && (0, import_menuHelpers.menuItem)(actions["edit-link"]),
            (0, import_menuHelpers.menuItem)(actions["duplicate"], { disabled: !oneSelected }),
            allowGroup && (0, import_menuHelpers.menuItem)(actions["group"]),
            allowUngroup && (0, import_menuHelpers.menuItem)(actions["ungroup"]),
            (0, import_menuHelpers.menuItem)(actions["unlock-all"], { disabled: emptyPage })
          ),
          (0, import_menuHelpers.menuGroup)("delete-group", (0, import_menuHelpers.menuItem)(actions["delete"], { disabled: !oneSelected })),
          (0, import_menuHelpers.menuGroup)(
            "embeds",
            oneEmbedSelected && (0, import_menuHelpers.menuItem)(actions["open-embed-link"]),
            oneEmbedSelected && (0, import_menuHelpers.menuItem)(actions["convert-to-bookmark"]),
            oneEmbeddableBookmarkSelected && (0, import_menuHelpers.menuItem)(actions["convert-to-embed"])
          )
        ),
        (0, import_menuHelpers.menuSubmenu)(
          "view",
          "menu.view",
          (0, import_menuHelpers.menuGroup)(
            "view-actions",
            (0, import_menuHelpers.menuItem)(actions["zoom-in"]),
            (0, import_menuHelpers.menuItem)(actions["zoom-out"]),
            (0, import_menuHelpers.menuItem)(actions["zoom-to-100"], { disabled: isZoomedTo100 }),
            (0, import_menuHelpers.menuItem)(actions["zoom-to-fit"], { disabled: emptyPage }),
            (0, import_menuHelpers.menuItem)(actions["zoom-to-selection"], { disabled: emptyPage || !oneSelected })
          )
        )
      ),
      (0, import_menuHelpers.menuGroup)("extras", (0, import_menuHelpers.menuItem)(actions["insert-embed"]), (0, import_menuHelpers.menuItem)(actions["insert-media"])),
      (0, import_menuHelpers.menuGroup)(
        "preferences",
        (0, import_menuHelpers.menuSubmenu)(
          "preferences",
          "menu.preferences",
          (0, import_menuHelpers.menuGroup)(
            "preferences-actions",
            (0, import_menuHelpers.menuItem)(actions["toggle-snap-mode"], { checked: isSnapMode }),
            (0, import_menuHelpers.menuItem)(actions["toggle-tool-lock"], { checked: isToolLock }),
            (0, import_menuHelpers.menuItem)(actions["toggle-grid"], { checked: isGridMode }),
            (0, import_menuHelpers.menuItem)(actions["toggle-dark-mode"], { checked: isDarkMode }),
            (0, import_menuHelpers.menuItem)(actions["toggle-focus-mode"], { checked: isFocusMode }),
            (0, import_menuHelpers.menuItem)(actions["toggle-reduce-motion"], { checked: animationSpeed === 0 }),
            (0, import_menuHelpers.menuItem)(actions["toggle-debug-mode"], { checked: isDebugMode })
          )
        ),
        isMobile && (0, import_menuHelpers.menuCustom)("LANGUAGE_MENU", { readonlyOk: true })
      )
    ]);
    if (overrides) {
      return overrides(editor, menuSchema2, {
        actions,
        noneSelected,
        oneSelected,
        twoSelected,
        threeSelected
      });
    }
    return menuSchema2;
  }, [
    editor,
    overrides,
    actions,
    oneSelected,
    twoSelected,
    threeSelected,
    emptyPage,
    isMobile,
    allowGroup,
    allowUngroup,
    showEditLink,
    hasClipboardWrite,
    showAutoSizeToggle,
    noneSelected,
    canUndo,
    canRedo,
    animationSpeed,
    isDarkMode,
    isGridMode,
    isSnapMode,
    isToolLock,
    isFocusMode,
    exportBackground,
    isDebugMode,
    isZoomedTo100,
    oneEmbeddableBookmarkSelected,
    oneEmbedSelected
  ]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(TLUiMenuSchemaContext.Provider, { value: menuSchema, children });
}
function useMenuSchema() {
  const ctx = import_react.default.useContext(TLUiMenuSchemaContext);
  if (!ctx) {
    throw new Error("useMenuSchema must be used inside of a TLUiMenuSchemaProvider.");
  }
  return ctx;
}
//# sourceMappingURL=useMenuSchema.js.map
