"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var rotated_box_shadow_exports = {};
__export(rotated_box_shadow_exports, {
  ROTATING_BOX_SHADOWS: () => ROTATING_BOX_SHADOWS,
  getRotatedBoxShadow: () => getRotatedBoxShadow
});
module.exports = __toCommonJS(rotated_box_shadow_exports);
var import_editor = require("@tldraw/editor");
const ROTATING_BOX_SHADOWS = [
  {
    offsetX: 0,
    offsetY: 2,
    blur: 4,
    spread: 0,
    color: "#00000029"
  },
  {
    offsetX: 0,
    offsetY: 3,
    blur: 6,
    spread: 0,
    color: "#0000001f"
  }
];
function getRotatedBoxShadow(rotation) {
  const cssStrings = ROTATING_BOX_SHADOWS.map((shadow) => {
    const { offsetX, offsetY, blur, spread, color } = shadow;
    const vec = new import_editor.Vec2d(offsetX, offsetY);
    const { x, y } = vec.rot(-rotation);
    return `${x}px ${y}px ${blur}px ${spread}px ${color}`;
  });
  return cssStrings.join(", ");
}
//# sourceMappingURL=rotated-box-shadow.js.map
