import { StateNode } from "@tldraw/editor";
import { Brushing } from "./children/Brushing.mjs";
import { Crop } from "./children/Crop/Crop.mjs";
import { Cropping } from "./children/Cropping.mjs";
import { DraggingHandle } from "./children/DraggingHandle.mjs";
import { EditingShape } from "./children/EditingShape.mjs";
import { Idle } from "./children/Idle.mjs";
import { PointingCanvas } from "./children/PointingCanvas.mjs";
import { PointingCropHandle } from "./children/PointingCropHandle.mjs";
import { PointingHandle } from "./children/PointingHandle.mjs";
import { PointingResizeHandle } from "./children/PointingResizeHandle.mjs";
import { PointingRotateHandle } from "./children/PointingRotateHandle.mjs";
import { PointingSelection } from "./children/PointingSelection.mjs";
import { PointingShape } from "./children/PointingShape.mjs";
import { Resizing } from "./children/Resizing.mjs";
import { Rotating } from "./children/Rotating.mjs";
import { ScribbleBrushing } from "./children/ScribbleBrushing.mjs";
import { Translating } from "./children/Translating.mjs";
class SelectTool extends StateNode {
  static id = "select";
  static initial = "idle";
  static children = () => [
    Crop,
    Cropping,
    Idle,
    PointingCanvas,
    PointingShape,
    Translating,
    Brushing,
    ScribbleBrushing,
    PointingCropHandle,
    PointingSelection,
    PointingResizeHandle,
    EditingShape,
    Resizing,
    Rotating,
    PointingRotateHandle,
    PointingHandle,
    DraggingHandle
  ];
  onExit = () => {
    if (this.editor.currentPageState.editingShapeId) {
      this.editor.setEditingShape(null);
    }
  };
}
export {
  SelectTool
};
//# sourceMappingURL=SelectTool.mjs.map
