import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import { EMBED_DEFINITIONS, track, useEditor } from "@tldraw/editor";
import { useRef, useState } from "react";
import { getEmbedInfo } from "../../utils/embeds.mjs";
import { useAssetUrls } from "../hooks/useAssetUrls.mjs";
import { useTranslation } from "../hooks/useTranslation/useTranslation.mjs";
import { Button } from "./primitives/Button.mjs";
import * as Dialog from "./primitives/Dialog.mjs";
import { Icon } from "./primitives/Icon.mjs";
import { Input } from "./primitives/Input.mjs";
const EmbedDialog = track(function EmbedDialog2({ onClose }) {
  const editor = useEditor();
  const msg = useTranslation();
  const assetUrls = useAssetUrls();
  const [embedDefinition, setEmbedDefinition] = useState(null);
  const [url, setUrl] = useState("");
  const [embedInfoForUrl, setEmbedInfoForUrl] = useState(null);
  const [showError, setShowError] = useState(false);
  const rShowErrorTimeout = useRef(-1);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(Dialog.Header, { children: [
      /* @__PURE__ */ jsx(Dialog.Title, { children: embedDefinition ? `${msg("embed-dialog.title")} \u2014 ${embedDefinition.title}` : msg("embed-dialog.title") }),
      /* @__PURE__ */ jsx(Dialog.CloseButton, {})
    ] }),
    embedDefinition ? /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsxs(Dialog.Body, { className: "tlui-embed-dialog__enter", children: [
        /* @__PURE__ */ jsx(
          Input,
          {
            className: "tlui-embed-dialog__input",
            label: "embed-dialog.url",
            placeholder: "http://example.com",
            autofocus: true,
            onValueChange: (value) => {
              setUrl(value);
              const embedInfo = getEmbedInfo(value);
              setEmbedInfoForUrl(
                embedInfo && embedInfo.definition.type === embedDefinition.type ? embedInfo : null
              );
              setShowError(false);
              clearTimeout(rShowErrorTimeout.current);
              rShowErrorTimeout.current = setTimeout(() => setShowError(!embedInfo), 320);
            }
          }
        ),
        url === "" ? /* @__PURE__ */ jsxs("div", { className: "tlui-embed-dialog__instruction", children: [
          /* @__PURE__ */ jsx("span", { children: msg("embed-dialog.instruction") }),
          " ",
          embedDefinition.instructionLink && /* @__PURE__ */ jsxs(
            "a",
            {
              target: "_blank",
              rel: "noopener noreferrer",
              href: embedDefinition.instructionLink,
              className: "tlui-embed-dialog__instruction__link",
              children: [
                "Learn more.",
                /* @__PURE__ */ jsx(Icon, { icon: "external-link", small: true })
              ]
            }
          )
        ] }) : /* @__PURE__ */ jsx("div", { className: "tlui-embed-dialog__warning", children: showError ? msg("embed-dialog.invalid-url") : "\xA0" })
      ] }),
      /* @__PURE__ */ jsxs(Dialog.Footer, { className: "tlui-dialog__footer__actions", children: [
        /* @__PURE__ */ jsx(
          Button,
          {
            onClick: () => {
              setEmbedDefinition(null);
              setEmbedInfoForUrl(null);
              setUrl("");
            },
            label: "embed-dialog.back"
          }
        ),
        /* @__PURE__ */ jsx("div", { className: "tlui-embed__spacer" }),
        /* @__PURE__ */ jsx(Button, { label: "embed-dialog.cancel", onClick: onClose }),
        /* @__PURE__ */ jsx(
          Button,
          {
            type: "primary",
            disabled: !embedInfoForUrl,
            label: "embed-dialog.create",
            onClick: () => {
              if (!embedInfoForUrl)
                return;
              editor.putExternalContent({
                type: "embed",
                url,
                point: editor.viewportPageCenter,
                embed: embedInfoForUrl.definition
              });
              onClose();
            }
          }
        )
      ] })
    ] }) : /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx(Dialog.Body, { className: "tlui-embed-dialog__list", children: EMBED_DEFINITIONS.map((def) => {
        return /* @__PURE__ */ jsxs(
          "button",
          {
            className: "tlui-embed-dialog__item",
            onClick: () => setEmbedDefinition(def),
            children: [
              /* @__PURE__ */ jsx("div", { className: "tlui-embed-dialog__item__image", children: /* @__PURE__ */ jsx(
                "div",
                {
                  className: "tlui-embed-dialog__item__image__img",
                  style: {
                    backgroundImage: `url(${assetUrls.embedIcons[def.type]})`
                  }
                }
              ) }),
              /* @__PURE__ */ jsx("div", { className: "tlui-embed-dialog__item__title", children: def.title })
            ]
          },
          def.type
        );
      }) }),
      /* @__PURE__ */ jsx("div", { className: "tlui-dialog__scrim" })
    ] })
  ] });
});
export {
  EmbedDialog
};
//# sourceMappingURL=EmbedDialog.mjs.map
