import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import { useEditor } from "@tldraw/editor";
import * as React from "react";
import { useBreakpoint } from "../hooks/useBreakpoint.mjs";
import { useMenuSchema } from "../hooks/useMenuSchema.mjs";
import { useReadonly } from "../hooks/useReadonly.mjs";
import { useTranslation } from "../hooks/useTranslation/useTranslation.mjs";
import { LanguageMenu } from "./LanguageMenu.mjs";
import { Button } from "./primitives/Button.mjs";
import * as M from "./primitives/DropdownMenu.mjs";
import { Kbd } from "./primitives/Kbd.mjs";
const Menu = React.memo(function Menu2() {
  const msg = useTranslation();
  return /* @__PURE__ */ jsxs(M.Root, { id: "main menu", children: [
    /* @__PURE__ */ jsx(M.Trigger, { children: /* @__PURE__ */ jsx(
      Button,
      {
        className: "tlui-menu__trigger",
        "data-testid": "main.menu",
        title: msg("menu.title"),
        icon: "menu"
      }
    ) }),
    /* @__PURE__ */ jsx(M.Content, { alignOffset: 0, sideOffset: 6, children: /* @__PURE__ */ jsx(MenuContent, {}) })
  ] });
});
function MenuContent() {
  const editor = useEditor();
  const msg = useTranslation();
  const menuSchema = useMenuSchema();
  const breakpoint = useBreakpoint();
  const isReadonly = useReadonly();
  function getMenuItem(editor2, item, parent, depth) {
    switch (item.type) {
      case "custom": {
        if (isReadonly && !item.readonlyOk)
          return null;
        if (item.id === "LANGUAGE_MENU") {
          return /* @__PURE__ */ jsx(LanguageMenu, {}, "item");
        }
        return null;
      }
      case "group": {
        if (isReadonly && !item.readonlyOk)
          return null;
        return /* @__PURE__ */ jsx(
          M.Group,
          {
            size: depth <= 1 ? "medium" : breakpoint < 3 || parent?.type === "submenu" && depth > 2 ? "tiny" : "medium",
            children: item.children.map((child) => getMenuItem(editor2, child, item, depth + 1))
          },
          item.id
        );
      }
      case "submenu": {
        if (isReadonly && !item.readonlyOk)
          return null;
        return /* @__PURE__ */ jsxs(M.Sub, { id: `main menu ${parent ? parent.id + " " : ""}${item.id}`, children: [
          /* @__PURE__ */ jsx(M.SubTrigger, { label: item.label, "data-testid": `menu-item.${item.id}` }),
          /* @__PURE__ */ jsx(M.SubContent, { sideOffset: -4, alignOffset: -1, children: item.children.map((child) => getMenuItem(editor2, child, item, depth + 1)) })
        ] }, item.id);
      }
      case "item": {
        if (isReadonly && !item.readonlyOk)
          return null;
        const { id, checkbox, menuLabel, label, onSelect, kbd } = item.actionItem;
        const labelToUse = menuLabel ?? label;
        const labelStr = labelToUse ? msg(labelToUse) : void 0;
        if (checkbox) {
          return /* @__PURE__ */ jsxs(
            M.CheckboxItem,
            {
              onSelect: () => onSelect("menu"),
              title: labelStr ? labelStr : "",
              checked: item.checked,
              disabled: item.disabled,
              children: [
                labelStr && /* @__PURE__ */ jsx("span", { children: labelStr }),
                kbd && /* @__PURE__ */ jsx(Kbd, { children: kbd })
              ]
            },
            id
          );
        }
        return /* @__PURE__ */ jsx(
          M.Item,
          {
            "data-testid": `menu-item.${item.id}`,
            kbd,
            label: labelToUse,
            onClick: () => onSelect("menu"),
            disabled: item.disabled
          },
          id
        );
      }
    }
  }
  return /* @__PURE__ */ jsx(Fragment, { children: menuSchema.map((item) => getMenuItem(editor, item, null, 0)) });
}
export {
  Menu
};
//# sourceMappingURL=Menu.mjs.map
