import { jsx, jsxs } from "react/jsx-runtime";
import * as _ContextMenu from "@radix-ui/react-context-menu";
import { PageRecordType, track, useContainer, useEditor } from "@tldraw/editor";
import { useToasts } from "../hooks/useToastsProvider.mjs";
import { useTranslation } from "../hooks/useTranslation/useTranslation.mjs";
import { Button } from "./primitives/Button.mjs";
const MoveToPageMenu = track(function MoveToPageMenu2() {
  const editor = useEditor();
  const container = useContainer();
  const pages = editor.pages;
  const currentPageId = editor.currentPageId;
  const msg = useTranslation();
  const { addToast } = useToasts();
  return /* @__PURE__ */ jsxs(_ContextMenu.Sub, { children: [
    /* @__PURE__ */ jsx(_ContextMenu.SubTrigger, { dir: "ltr", asChild: true, children: /* @__PURE__ */ jsx(
      Button,
      {
        className: "tlui-menu__button",
        label: "context-menu.move-to-page",
        "data-testid": "menu-item.move-to-page",
        icon: "chevron-right"
      }
    ) }),
    /* @__PURE__ */ jsx(_ContextMenu.Portal, { container, dir: "ltr", children: /* @__PURE__ */ jsxs(_ContextMenu.SubContent, { className: "tlui-menu", sideOffset: -4, collisionPadding: 4, children: [
      /* @__PURE__ */ jsx(
        _ContextMenu.Group,
        {
          dir: "ltr",
          className: "tlui-menu__group",
          "data-testid": `menu-item.pages`,
          children: pages.map((page) => /* @__PURE__ */ jsx(
            _ContextMenu.Item,
            {
              disabled: currentPageId === page.id,
              onSelect: () => {
                editor.mark("move_shapes_to_page");
                editor.moveShapesToPage(editor.selectedShapeIds, page.id);
                const toPage = editor.getPage(page.id);
                if (toPage) {
                  addToast({
                    title: "Changed Page",
                    description: `Moved to ${toPage.name}.`,
                    actions: [
                      {
                        label: "Go Back",
                        type: "primary",
                        onClick: () => {
                          editor.mark("change-page");
                          editor.setCurrentPage(currentPageId);
                        }
                      }
                    ]
                  });
                }
              },
              asChild: true,
              children: /* @__PURE__ */ jsx(
                Button,
                {
                  title: page.name,
                  className: "tlui-menu__button tlui-context-menu__move-to-page__name",
                  children: /* @__PURE__ */ jsx("span", { children: page.name })
                }
              )
            },
            page.id
          ))
        },
        "pages"
      ),
      /* @__PURE__ */ jsx(
        _ContextMenu.Group,
        {
          dir: "ltr",
          className: "tlui-menu__group",
          "data-testid": `menu-item.new-page`,
          children: /* @__PURE__ */ jsx(
            _ContextMenu.Item,
            {
              onSelect: () => {
                const newPageId = PageRecordType.createId();
                const ids = editor.selectedShapeIds;
                editor.batch(() => {
                  editor.mark("move_shapes_to_page");
                  editor.createPage({ name: "Page", id: newPageId });
                  editor.moveShapesToPage(ids, newPageId);
                });
              },
              asChild: true,
              children: /* @__PURE__ */ jsx(
                Button,
                {
                  title: msg("context.pages.new-page"),
                  className: "tlui-menu__button tlui-context-menu__move-to-page__name",
                  children: msg("context.pages.new-page")
                }
              )
            },
            "new-page"
          )
        },
        "new-page"
      )
    ] }) })
  ] });
});
export {
  MoveToPageMenu
};
//# sourceMappingURL=MoveToPageMenu.mjs.map
