import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import { memo, useCallback } from "react";
import { useActions } from "../../hooks/useActions.mjs";
import { useBreakpoint } from "../../hooks/useBreakpoint.mjs";
import { useLocalStorageState } from "../../hooks/useLocalStorageState.mjs";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { Button } from "../primitives/Button.mjs";
import { kbdStr } from "../primitives/shared.mjs";
import { Minimap } from "./Minimap.mjs";
import { ZoomMenu } from "./ZoomMenu.mjs";
const NavigationZone = memo(function NavigationZone2() {
  const actions = useActions();
  const msg = useTranslation();
  const breakpoint = useBreakpoint();
  const [collapsed, setCollapsed] = useLocalStorageState("minimap", true);
  const toggleMinimap = useCallback(() => {
    setCollapsed((s) => !s);
  }, [setCollapsed]);
  if (breakpoint < 4) {
    return null;
  }
  return /* @__PURE__ */ jsxs("div", { className: "tlui-navigation-zone", children: [
    /* @__PURE__ */ jsx("div", { className: "tlui-navigation-zone__controls", children: breakpoint < 6 ? /* @__PURE__ */ jsx(ZoomMenu, {}) : collapsed ? /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx(ZoomMenu, {}),
      /* @__PURE__ */ jsx(
        Button,
        {
          title: msg("navigation-zone.toggle-minimap"),
          className: "tlui-navigation-zone__toggle",
          "data-testid": "minimap.toggle",
          onClick: toggleMinimap,
          icon: collapsed ? "chevrons-ne" : "chevrons-sw"
        }
      )
    ] }) : /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx(
        Button,
        {
          icon: "minus",
          "data-testid": "minimap.zoom-out",
          title: `${msg(actions["zoom-out"].label)} ${kbdStr(actions["zoom-out"].kbd)}`,
          onClick: () => actions["zoom-out"].onSelect("navigation-zone")
        }
      ),
      /* @__PURE__ */ jsx(ZoomMenu, {}),
      /* @__PURE__ */ jsx(
        Button,
        {
          icon: "plus",
          "data-testid": "minimap.zoom-in",
          title: `${msg(actions["zoom-in"].label)} ${kbdStr(actions["zoom-in"].kbd)}`,
          onClick: () => actions["zoom-in"].onSelect("navigation-zone")
        }
      ),
      /* @__PURE__ */ jsx(
        Button,
        {
          title: msg("navigation-zone.toggle-minimap"),
          className: "tlui-navigation-zone__toggle",
          onClick: toggleMinimap,
          icon: collapsed ? "chevrons-ne" : "chevrons-sw"
        }
      )
    ] }) }),
    breakpoint >= 6 && !collapsed && /* @__PURE__ */ jsx(
      Minimap,
      {
        viewportFill: "--color-muted-1",
        selectFill: "--color-selected",
        shapeFill: "--color-text-3"
      }
    )
  ] });
});
export {
  NavigationZone
};
//# sourceMappingURL=NavigationZone.mjs.map
