import { jsx, jsxs } from "react/jsx-runtime";
import { ANIMATION_MEDIUM_MS, track, useEditor } from "@tldraw/editor";
import * as React from "react";
import { useActions } from "../../hooks/useActions.mjs";
import { useBreakpoint } from "../../hooks/useBreakpoint.mjs";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { Button } from "../primitives/Button.mjs";
import * as M from "../primitives/DropdownMenu.mjs";
const ZoomMenu = track(function ZoomMenu2() {
  const editor = useEditor();
  const msg = useTranslation();
  const breakpoint = useBreakpoint();
  const zoom = editor.zoomLevel;
  const hasShapes = editor.currentPageShapeIds.size > 0;
  const hasSelected = editor.selectedShapeIds.length > 0;
  const isZoomedTo100 = editor.zoomLevel === 1;
  const handleDoubleClick = React.useCallback(() => {
    editor.resetZoom(editor.viewportScreenCenter, { duration: ANIMATION_MEDIUM_MS });
  }, [editor]);
  return /* @__PURE__ */ jsxs(M.Root, { id: "zoom", children: [
    /* @__PURE__ */ jsx(M.Trigger, { children: /* @__PURE__ */ jsx(
      Button,
      {
        title: `${msg("navigation-zone.zoom")}`,
        "data-testid": "minimap.zoom-menu",
        className: breakpoint < 5 ? "tlui-zoom-menu__button" : "tlui-zoom-menu__button__pct",
        onDoubleClick: handleDoubleClick,
        icon: breakpoint < 4 ? "zoom-in" : void 0,
        children: breakpoint < 4 ? null : /* @__PURE__ */ jsxs("span", { style: { flexGrow: 0, textAlign: "center" }, children: [
          Math.floor(zoom * 100),
          "%"
        ] })
      }
    ) }),
    /* @__PURE__ */ jsx(M.Content, { side: "top", align: "start", alignOffset: 0, children: /* @__PURE__ */ jsxs(M.Group, { children: [
      /* @__PURE__ */ jsx(ZoomMenuItem, { action: "zoom-in", "data-testid": "minimap.zoom-menu.zoom-in", noClose: true }),
      /* @__PURE__ */ jsx(ZoomMenuItem, { action: "zoom-out", "data-testid": "minimap.zoom-menu.zoom-out", noClose: true }),
      /* @__PURE__ */ jsx(
        ZoomMenuItem,
        {
          action: "zoom-to-100",
          "data-testid": "minimap.zoom-menu.zoom-to-100",
          noClose: true,
          disabled: isZoomedTo100
        }
      ),
      /* @__PURE__ */ jsx(
        ZoomMenuItem,
        {
          action: "zoom-to-fit",
          disabled: !hasShapes,
          "data-testid": "minimap.zoom-menu.zoom-to-fit",
          noClose: true
        }
      ),
      /* @__PURE__ */ jsx(
        ZoomMenuItem,
        {
          action: "zoom-to-selection",
          disabled: !hasSelected,
          "data-testid": "minimap.zoom-menu.zoom-to-selection",
          noClose: true
        }
      )
    ] }) })
  ] });
});
function ZoomMenuItem(props) {
  const { action, disabled = false, noClose = false } = props;
  const actions = useActions();
  return /* @__PURE__ */ jsx(
    M.Item,
    {
      label: actions[action].label,
      kbd: actions[action].kbd,
      "data-testid": props["data-testid"],
      onClick: () => actions[action].onSelect("zoom-menu"),
      noClose,
      disabled
    }
  );
}
export {
  ZoomMenu
};
//# sourceMappingURL=ZoomMenu.mjs.map
