import { jsx, jsxs } from "react/jsx-runtime";
import * as DropdownMenu from "@radix-ui/react-dropdown-menu";
import { MAX_PAGES, PageRecordType, track, useEditor } from "@tldraw/editor";
import { useCallback } from "react";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { Button } from "../primitives/Button.mjs";
import * as M from "../primitives/DropdownMenu.mjs";
import { onMovePage } from "./edit-pages-shared.mjs";
const PageItemSubmenu = track(function PageItemSubmenu2({
  index,
  listSize,
  item,
  onRename
}) {
  const editor = useEditor();
  const msg = useTranslation();
  const pages = editor.pages;
  const onDuplicate = useCallback(() => {
    editor.mark("creating page");
    const newId = PageRecordType.createId();
    editor.duplicatePage(item.id, newId);
  }, [editor, item]);
  const onMoveUp = useCallback(() => {
    onMovePage(editor, item.id, index, index - 1);
  }, [editor, item, index]);
  const onMoveDown = useCallback(() => {
    onMovePage(editor, item.id, index, index + 1);
  }, [editor, item, index]);
  const onDelete = useCallback(() => {
    editor.mark("deleting page");
    editor.deletePage(item.id);
  }, [editor, item]);
  return /* @__PURE__ */ jsxs(M.Root, { id: `page item submenu ${index}`, children: [
    /* @__PURE__ */ jsx(M.Trigger, { children: /* @__PURE__ */ jsx(Button, { title: msg("page-menu.submenu.title"), icon: "dots-vertical" }) }),
    /* @__PURE__ */ jsxs(M.Content, { alignOffset: 0, children: [
      /* @__PURE__ */ jsxs(M.Group, { children: [
        onRename && /* @__PURE__ */ jsx(DropdownMenu.Item, { dir: "ltr", onSelect: onRename, asChild: true, children: /* @__PURE__ */ jsx(Button, { className: "tlui-menu__button", label: "page-menu.submenu.rename" }) }),
        /* @__PURE__ */ jsx(
          DropdownMenu.Item,
          {
            dir: "ltr",
            onSelect: onDuplicate,
            disabled: pages.length >= MAX_PAGES,
            asChild: true,
            children: /* @__PURE__ */ jsx(Button, { className: "tlui-menu__button", label: "page-menu.submenu.duplicate-page" })
          }
        ),
        index > 0 && /* @__PURE__ */ jsx(DropdownMenu.Item, { dir: "ltr", onSelect: onMoveUp, asChild: true, children: /* @__PURE__ */ jsx(Button, { className: "tlui-menu__button", label: "page-menu.submenu.move-up" }) }),
        index < listSize - 1 && /* @__PURE__ */ jsx(DropdownMenu.Item, { dir: "ltr", onSelect: onMoveDown, asChild: true, children: /* @__PURE__ */ jsx(Button, { className: "tlui-menu__button", label: "page-menu.submenu.move-down" }) })
      ] }),
      listSize > 1 && /* @__PURE__ */ jsx(M.Group, { children: /* @__PURE__ */ jsx(DropdownMenu.Item, { dir: "ltr", onSelect: onDelete, asChild: true, children: /* @__PURE__ */ jsx(Button, { className: "tlui-menu__button", label: "page-menu.submenu.delete" }) }) })
    ] })
  ] });
});
export {
  PageItemSubmenu
};
//# sourceMappingURL=PageItemSubmenu.mjs.map
