import { jsx } from "react/jsx-runtime";
import { memo } from "react";
import { useActions } from "../hooks/useActions.mjs";
import { useCanRedo } from "../hooks/useCanRedo.mjs";
import { useTranslation } from "../hooks/useTranslation/useTranslation.mjs";
import { Button } from "./primitives/Button.mjs";
import { kbdStr } from "./primitives/shared.mjs";
const RedoButton = memo(function RedoButton2() {
  const msg = useTranslation();
  const canRedo = useCanRedo();
  const actions = useActions();
  const redo = actions["redo"];
  return /* @__PURE__ */ jsx(
    Button,
    {
      "data-testid": "main.redo",
      icon: redo.icon,
      title: `${msg(redo.label)} ${kbdStr(redo.kbd)}`,
      disabled: !canRedo,
      onClick: () => redo.onSelect("quick-actions"),
      smallIcon: true
    }
  );
});
export {
  RedoButton
};
//# sourceMappingURL=RedoButton.mjs.map
