import { jsx } from "react/jsx-runtime";
import { useEditor, useValue } from "@tldraw/editor";
import classNames from "classnames";
import { useBreakpoint } from "../../hooks/useBreakpoint.mjs";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { Button } from "../primitives/Button.mjs";
const NOT_LOCKABLE_TOOLS = [
  "select",
  "hand",
  "draw",
  "eraser",
  "text",
  "zoom",
  "laser",
  "highlight"
];
function ToggleToolLockedButton({ activeToolId }) {
  const editor = useEditor();
  const breakpoint = useBreakpoint();
  const msg = useTranslation();
  const isToolLocked = useValue("is tool locked", () => editor.instanceState.isToolLocked, [editor]);
  if (!activeToolId || NOT_LOCKABLE_TOOLS.includes(activeToolId))
    return null;
  return /* @__PURE__ */ jsx(
    Button,
    {
      title: msg("action.toggle-tool-lock"),
      className: classNames("tlui-toolbar__lock-button", {
        "tlui-toolbar__lock-button__mobile": breakpoint < 5
      }),
      icon: isToolLocked ? "lock" : "unlock",
      onClick: () => editor.updateInstanceState({ isToolLocked: !isToolLocked }),
      smallIcon: true
    }
  );
}
export {
  ToggleToolLockedButton
};
//# sourceMappingURL=ToggleToolLockedButton.mjs.map
