import { jsx } from "react/jsx-runtime";
import {
  DefaultColorStyle,
  clamp,
  getDefaultColorTheme,
  useEditor,
  useValue
} from "@tldraw/editor";
import classNames from "classnames";
import * as React from "react";
import { useRef } from "react";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { Button } from "./Button.mjs";
function _ButtonPicker(props) {
  const {
    uiType,
    items,
    title,
    style,
    value,
    columns = clamp(items.length, 2, 4),
    onValueChange
  } = props;
  const editor = useEditor();
  const msg = useTranslation();
  const rPointing = useRef(false);
  const {
    handleButtonClick,
    handleButtonPointerDown,
    handleButtonPointerEnter,
    handleButtonPointerUp
  } = React.useMemo(() => {
    const handlePointerUp = () => {
      rPointing.current = false;
      window.removeEventListener("pointerup", handlePointerUp);
    };
    const handleButtonClick2 = (e) => {
      const { id } = e.currentTarget.dataset;
      if (value.type === "shared" && value.value === id)
        return;
      editor.mark("point picker item");
      onValueChange(style, id, false);
    };
    const handleButtonPointerDown2 = (e) => {
      const { id } = e.currentTarget.dataset;
      editor.mark("point picker item");
      onValueChange(style, id, true);
      rPointing.current = true;
      window.addEventListener("pointerup", handlePointerUp);
    };
    const handleButtonPointerEnter2 = (e) => {
      if (!rPointing.current)
        return;
      const { id } = e.currentTarget.dataset;
      onValueChange(style, id, true);
    };
    const handleButtonPointerUp2 = (e) => {
      const { id } = e.currentTarget.dataset;
      onValueChange(style, id, false);
    };
    return {
      handleButtonClick: handleButtonClick2,
      handleButtonPointerDown: handleButtonPointerDown2,
      handleButtonPointerEnter: handleButtonPointerEnter2,
      handleButtonPointerUp: handleButtonPointerUp2
    };
  }, [value, editor, onValueChange, style]);
  const theme = useValue(
    "theme",
    () => getDefaultColorTheme({ isDarkMode: editor.user.isDarkMode }),
    [editor]
  );
  return /* @__PURE__ */ jsx(
    "div",
    {
      className: classNames("tlui-button-grid", {
        "tlui-button-grid__two": columns === 2,
        "tlui-button-grid__three": columns === 3,
        "tlui-button-grid__four": columns === 4
      }),
      children: items.map((item) => /* @__PURE__ */ jsx(
        Button,
        {
          "data-id": item.value,
          "data-testid": `style.${uiType}.${item.value}`,
          "aria-label": item.value,
          "data-state": value.type === "shared" && value.value === item.value ? "hinted" : void 0,
          title: title + " \u2014 " + msg(`${uiType}-style.${item.value}`),
          className: classNames("tlui-button-grid__button"),
          style: style === DefaultColorStyle ? { color: theme[item.value].solid } : void 0,
          onPointerEnter: handleButtonPointerEnter,
          onPointerDown: handleButtonPointerDown,
          onPointerUp: handleButtonPointerUp,
          onClick: handleButtonClick,
          icon: item.icon
        },
        item.value
      ))
    }
  );
}
const ButtonPicker = React.memo(_ButtonPicker);
export {
  ButtonPicker
};
//# sourceMappingURL=ButtonPicker.mjs.map
