import { jsx } from "react/jsx-runtime";
import * as _Dialog from "@radix-ui/react-dialog";
import classNames from "classnames";
import { Button } from "./Button.mjs";
import { Icon } from "./Icon.mjs";
function Header({ className, children }) {
  return /* @__PURE__ */ jsx("div", { className: classNames("tlui-dialog__header", className), children });
}
function Title({ className, children }) {
  return /* @__PURE__ */ jsx(_Dialog.DialogTitle, { dir: "ltr", className: classNames("tlui-dialog__header__title", className), children });
}
function CloseButton() {
  return /* @__PURE__ */ jsx("div", { className: "tlui-dialog__header__close", children: /* @__PURE__ */ jsx(_Dialog.DialogClose, { "data-testid": "dialog.close", dir: "ltr", asChild: true, children: /* @__PURE__ */ jsx(Button, { "aria-label": "Close", onTouchEnd: (e) => e.target.click(), children: /* @__PURE__ */ jsx(Icon, { small: true, icon: "cross-2" }) }) }) });
}
function Body({
  className,
  children,
  style
}) {
  return /* @__PURE__ */ jsx("div", { className: classNames("tlui-dialog__body", className), style, children });
}
function Footer({ className, children }) {
  return /* @__PURE__ */ jsx("div", { className: classNames("tlui-dialog__footer", className), children });
}
export {
  Body,
  CloseButton,
  Footer,
  Header,
  Title
};
//# sourceMappingURL=Dialog.mjs.map
