import { jsx, jsxs } from "react/jsx-runtime";
import * as DropdownMenu from "@radix-ui/react-dropdown-menu";
import { preventDefault, useContainer } from "@tldraw/editor";
import { useMenuIsOpen } from "../../hooks/useMenuIsOpen.mjs";
import { Button } from "./Button.mjs";
import { Icon } from "./Icon.mjs";
function Root({
  id,
  children,
  modal = false
}) {
  const [open, onOpenChange] = useMenuIsOpen(id);
  return /* @__PURE__ */ jsx(DropdownMenu.Root, { open, dir: "ltr", modal, onOpenChange, children });
}
function Trigger({
  children,
  "data-testid": testId
}) {
  return /* @__PURE__ */ jsx(
    DropdownMenu.Trigger,
    {
      dir: "ltr",
      "data-testid": testId,
      asChild: true,
      onTouchEnd: (e) => preventDefault(e),
      children
    }
  );
}
function Content({
  side = "bottom",
  align = "start",
  sideOffset = 8,
  alignOffset = 8,
  children
}) {
  const container = useContainer();
  return /* @__PURE__ */ jsx(DropdownMenu.Portal, { dir: "ltr", container, children: /* @__PURE__ */ jsx(
    DropdownMenu.Content,
    {
      className: "tlui-menu",
      align,
      sideOffset,
      side,
      alignOffset,
      collisionPadding: 4,
      children
    }
  ) });
}
function Sub({ id, children }) {
  const [open, onOpenChange] = useMenuIsOpen(id);
  return /* @__PURE__ */ jsx(DropdownMenu.Sub, { open, onOpenChange, children });
}
function SubTrigger({
  label,
  "data-testid": testId,
  "data-direction": dataDirection
}) {
  return /* @__PURE__ */ jsx(DropdownMenu.SubTrigger, { dir: "ltr", "data-direction": dataDirection, "data-testid": testId, asChild: true, children: /* @__PURE__ */ jsx(
    Button,
    {
      className: "tlui-menu__button tlui-menu__submenu__trigger",
      label,
      icon: "chevron-right"
    }
  ) });
}
function SubContent({
  alignOffset = 0,
  sideOffset = 5,
  children
}) {
  const container = useContainer();
  return /* @__PURE__ */ jsx(DropdownMenu.Portal, { container, dir: "ltr", children: /* @__PURE__ */ jsx(
    DropdownMenu.SubContent,
    {
      className: "tlui-menu tlui-menu__submenu__content",
      alignOffset,
      sideOffset,
      collisionPadding: 4,
      children
    }
  ) });
}
function Group({
  children,
  size = "medium"
}) {
  return /* @__PURE__ */ jsx(DropdownMenu.Group, { dir: "ltr", className: "tlui-menu__group", "data-size": size, children });
}
function Indicator() {
  return /* @__PURE__ */ jsx(DropdownMenu.ItemIndicator, { dir: "ltr", asChild: true, children: /* @__PURE__ */ jsx(Icon, { icon: "check" }) });
}
function Item({ noClose, ...props }) {
  return /* @__PURE__ */ jsx(
    DropdownMenu.Item,
    {
      dir: "ltr",
      asChild: true,
      onClick: noClose || props.isChecked !== void 0 ? preventDefault : void 0,
      children: /* @__PURE__ */ jsx(Button, { className: "tlui-menu__button", ...props })
    }
  );
}
function CheckboxItem({ children, onSelect, ...rest }) {
  return /* @__PURE__ */ jsxs(
    DropdownMenu.CheckboxItem,
    {
      dir: "ltr",
      className: "tlui-button tlui-menu__button tlui-menu__checkbox-item",
      onSelect: (e) => {
        onSelect?.(e);
        preventDefault(e);
      },
      ...rest,
      children: [
        /* @__PURE__ */ jsx(
          "div",
          {
            className: "tlui-menu__checkbox-item__check",
            style: {
              transformOrigin: "75% center",
              transform: `scale(${rest.checked ? 1 : 0.5})`,
              opacity: rest.checked ? 1 : 0.5
            },
            children: /* @__PURE__ */ jsx(Icon, { small: true, icon: rest.checked ? "check" : "checkbox-empty" })
          }
        ),
        children
      ]
    }
  );
}
function RadioItem({ children, onSelect, ...rest }) {
  return /* @__PURE__ */ jsxs(
    DropdownMenu.CheckboxItem,
    {
      dir: "ltr",
      className: "tlui-button tlui-menu__button tlui-menu__checkbox-item",
      onSelect: (e) => {
        onSelect?.(e);
        preventDefault(e);
      },
      ...rest,
      children: [
        /* @__PURE__ */ jsx(DropdownMenu.ItemIndicator, { dir: "ltr", className: "tlui-menu__checkbox-item__check", children: /* @__PURE__ */ jsx(Icon, { icon: "check" }) }),
        children
      ]
    }
  );
}
export {
  CheckboxItem,
  Content,
  Group,
  Indicator,
  Item,
  RadioItem,
  Root,
  Sub,
  SubContent,
  SubTrigger,
  Trigger
};
//# sourceMappingURL=DropdownMenu.mjs.map
