import { jsx } from "react/jsx-runtime";
import * as PopoverPrimitive from "@radix-ui/react-popover";
import { useContainer } from "@tldraw/editor";
import { useMenuIsOpen } from "../../hooks/useMenuIsOpen.mjs";
const Popover = ({ id, children, onOpenChange }) => {
  const [isOpen, handleOpenChange] = useMenuIsOpen(id, onOpenChange);
  return /* @__PURE__ */ jsx(PopoverPrimitive.Root, { onOpenChange: handleOpenChange, open: isOpen, children: /* @__PURE__ */ jsx("div", { className: "tlui-popover", children }) });
};
const PopoverTrigger = ({ children, disabled, "data-testid": testId }) => {
  return /* @__PURE__ */ jsx(PopoverPrimitive.Trigger, { "data-testid": testId, disabled, asChild: true, dir: "ltr", children });
};
const PopoverContent = ({ side, children, align = "center", sideOffset = 8, alignOffset = 0 }) => {
  const container = useContainer();
  return /* @__PURE__ */ jsx(PopoverPrimitive.Portal, { dir: "ltr", container, children: /* @__PURE__ */ jsx(
    PopoverPrimitive.Content,
    {
      className: "tlui-popover__content",
      side,
      sideOffset,
      align,
      alignOffset,
      dir: "ltr",
      children
    }
  ) });
};
export {
  Popover,
  PopoverContent,
  PopoverTrigger
};
//# sourceMappingURL=Popover.mjs.map
