import { pasteFiles } from "./pasteFiles.mjs";
async function pasteUrl(editor, url, point, sources) {
  try {
    const resp = await fetch(url);
    if (resp.headers.get("content-type")?.match(/^image\//)) {
      editor.mark("paste");
      pasteFiles(editor, [url]);
      return;
    }
  } catch (err) {
    if (err.message !== "Failed to fetch") {
      console.error(err);
    }
  }
  editor.mark("paste");
  return await editor.putExternalContent({
    type: "url",
    point,
    url,
    sources
  });
}
export {
  pasteUrl
};
//# sourceMappingURL=pasteUrl.mjs.map
