import { jsx } from "react/jsx-runtime";
import { track, useEditor, useValue } from "@tldraw/editor";
import React, { useMemo } from "react";
import {
  compactMenuItems,
  menuCustom,
  menuGroup,
  menuItem,
  menuSubmenu,
  showMenuPaste,
  useAllowGroup,
  useAllowUngroup,
  useThreeStackableItems
} from "./menuHelpers.mjs";
import { useActions } from "./useActions.mjs";
import { useHasLinkShapeSelected } from "./useHasLinkShapeSelected.mjs";
import { useOnlyFlippableShape } from "./useOnlyFlippableShape.mjs";
import { useShowAutoSizeToggle } from "./useShowAutoSizeToggle.mjs";
const TLUiContextMenuSchemaContext = React.createContext(
  {}
);
const TLUiContextMenuSchemaProvider = track(function TLUiContextMenuSchemaProvider2({
  overrides,
  children
}) {
  const editor = useEditor();
  const actions = useActions();
  const showAutoSizeToggle = useShowAutoSizeToggle();
  const onlyFlippableShapeSelected = useOnlyFlippableShape();
  const selectedCount = editor.selectedShapeIds.length;
  const oneSelected = selectedCount > 0;
  const twoSelected = selectedCount > 1;
  const threeSelected = selectedCount > 2;
  const threeStackableItems = useThreeStackableItems();
  const atLeastOneShapeOnPage = useValue(
    "atLeastOneShapeOnPage",
    () => editor.currentPageShapeIds.size > 0,
    []
  );
  const isTransparentBg = useValue(
    "isTransparentBg",
    () => editor.instanceState.exportBackground,
    []
  );
  const allowGroup = useAllowGroup();
  const allowUngroup = useAllowUngroup();
  const hasClipboardWrite = Boolean(window.navigator.clipboard?.write);
  const showEditLink = useHasLinkShapeSelected();
  const { onlySelectedShape } = editor;
  const isShapeLocked = onlySelectedShape && editor.isShapeOrAncestorLocked(onlySelectedShape);
  const contextTLUiMenuSchema = useMemo(() => {
    let contextTLUiMenuSchema2 = compactMenuItems([
      menuGroup(
        "selection",
        showAutoSizeToggle && menuItem(actions["toggle-auto-size"]),
        showEditLink && !isShapeLocked && menuItem(actions["edit-link"]),
        oneSelected && !isShapeLocked && menuItem(actions["duplicate"]),
        allowGroup && !isShapeLocked && menuItem(actions["group"]),
        allowUngroup && !isShapeLocked && menuItem(actions["ungroup"]),
        oneSelected && menuItem(actions["toggle-lock"])
      ),
      menuGroup(
        "modify",
        (twoSelected || onlyFlippableShapeSelected) && menuSubmenu(
          "arrange",
          "context-menu.arrange",
          twoSelected && menuGroup(
            "align",
            menuItem(actions["align-left"]),
            menuItem(actions["align-center-horizontal"]),
            menuItem(actions["align-right"]),
            menuItem(actions["align-top"]),
            menuItem(actions["align-center-vertical"]),
            menuItem(actions["align-bottom"])
          ),
          threeSelected && menuGroup(
            "distribute",
            menuItem(actions["distribute-horizontal"]),
            menuItem(actions["distribute-vertical"])
          ),
          twoSelected && menuGroup(
            "stretch",
            menuItem(actions["stretch-horizontal"]),
            menuItem(actions["stretch-vertical"])
          ),
          onlyFlippableShapeSelected && !isShapeLocked && menuGroup(
            "flip",
            menuItem(actions["flip-horizontal"]),
            menuItem(actions["flip-vertical"])
          ),
          twoSelected && menuGroup(
            "order",
            menuItem(actions["pack"], { disabled: !twoSelected }),
            threeStackableItems && menuItem(actions["stack-vertical"]),
            threeStackableItems && menuItem(actions["stack-horizontal"])
          )
        ),
        oneSelected && !isShapeLocked && menuSubmenu(
          "reorder",
          "context-menu.reorder",
          menuGroup(
            "reorder",
            menuItem(actions["bring-to-front"]),
            menuItem(actions["bring-forward"]),
            menuItem(actions["send-backward"]),
            menuItem(actions["send-to-back"])
          )
        ),
        oneSelected && !isShapeLocked && menuCustom("MOVE_TO_PAGE_MENU", { readonlyOk: false })
      ),
      menuGroup(
        "clipboard-group",
        oneSelected && !isShapeLocked && menuItem(actions["cut"]),
        oneSelected && menuItem(actions["copy"]),
        showMenuPaste && menuItem(actions["paste"])
      ),
      atLeastOneShapeOnPage && menuGroup(
        "conversions",
        menuSubmenu(
          "copy-as",
          "context-menu.copy-as",
          menuGroup(
            "copy-as-group",
            menuItem(actions["copy-as-svg"]),
            hasClipboardWrite && menuItem(actions["copy-as-png"]),
            menuItem(actions["copy-as-json"])
          ),
          menuGroup(
            "export-bg",
            menuItem(actions["toggle-transparent"], { checked: !isTransparentBg })
          )
        ),
        menuSubmenu(
          "export-as",
          "context-menu.export-as",
          menuGroup(
            "export-as-group",
            menuItem(actions["export-as-svg"]),
            menuItem(actions["export-as-png"]),
            menuItem(actions["export-as-json"])
          ),
          menuGroup(
            "export-bg,",
            menuItem(actions["toggle-transparent"], { checked: !isTransparentBg })
          )
        )
      ),
      atLeastOneShapeOnPage && menuGroup(
        "set-selection-group",
        menuItem(actions["select-all"]),
        oneSelected && menuItem(actions["select-none"])
      ),
      oneSelected && !isShapeLocked && menuGroup("delete-group", menuItem(actions["delete"]))
    ]);
    if (overrides) {
      contextTLUiMenuSchema2 = overrides(editor, contextTLUiMenuSchema2, {
        actions,
        oneSelected,
        twoSelected,
        threeSelected,
        showAutoSizeToggle,
        showUngroup: allowUngroup,
        onlyFlippableShapeSelected
      });
    }
    return contextTLUiMenuSchema2;
  }, [
    editor,
    overrides,
    actions,
    oneSelected,
    twoSelected,
    threeSelected,
    showAutoSizeToggle,
    onlyFlippableShapeSelected,
    atLeastOneShapeOnPage,
    threeStackableItems,
    allowGroup,
    allowUngroup,
    hasClipboardWrite,
    showEditLink,
    // oneEmbedSelected,
    // oneEmbeddableBookmarkSelected,
    isTransparentBg,
    isShapeLocked
  ]);
  return /* @__PURE__ */ jsx(TLUiContextMenuSchemaContext.Provider, { value: contextTLUiMenuSchema, children });
});
function useContextMenuSchema() {
  const ctx = React.useContext(TLUiContextMenuSchemaContext);
  if (!ctx) {
    throw new Error("useContextMenuSchema must be used inside of a TLUiContextMenuSchemaProvider.");
  }
  return ctx;
}
export {
  TLUiContextMenuSchemaContext,
  TLUiContextMenuSchemaProvider,
  useContextMenuSchema
};
//# sourceMappingURL=useContextMenuSchema.mjs.map
