import { getBrowserCanvasMaxSize } from "../shapes/shared/getBrowserCanvasMaxSize.mjs";
import { isAnimated } from "./is-gif-animated.mjs";
function containBoxSize(originalSize, containBoxSize2) {
  const overByXScale = originalSize.w / containBoxSize2.w;
  const overByYScale = originalSize.h / containBoxSize2.h;
  if (overByXScale <= 1 && overByYScale <= 1) {
    return originalSize;
  } else if (overByXScale > overByYScale) {
    return {
      w: originalSize.w / overByXScale,
      h: originalSize.h / overByXScale
    };
  } else {
    return {
      w: originalSize.w / overByYScale,
      h: originalSize.h / overByYScale
    };
  }
}
async function getResizedImageDataUrl(dataURLForImage, width, height) {
  return await new Promise((resolve) => {
    const img = new Image();
    img.onload = async () => {
      const canvas = document.createElement("canvas");
      const ctx = canvas.getContext("2d");
      if (!ctx)
        return;
      const canvasSizes = await getBrowserCanvasMaxSize();
      let desiredWidth = width * 2;
      let desiredHeight = height * 2;
      const aspectRatio = img.width / img.height;
      if (desiredWidth > canvasSizes.maxWidth) {
        desiredWidth = canvasSizes.maxWidth;
        desiredHeight = desiredWidth / aspectRatio;
      }
      if (desiredHeight > canvasSizes.maxHeight) {
        desiredHeight = canvasSizes.maxHeight;
        desiredWidth = desiredHeight * aspectRatio;
      }
      if (desiredWidth * desiredHeight > canvasSizes.maxArea) {
        const ratio = Math.sqrt(canvasSizes.maxArea / (desiredWidth * desiredHeight));
        desiredWidth *= ratio;
        desiredHeight *= ratio;
      }
      canvas.width = desiredWidth;
      canvas.height = desiredHeight;
      ctx.drawImage(img, 0, 0, canvas.width, canvas.height);
      const newDataURL = canvas.toDataURL();
      resolve(newDataURL);
    };
    img.crossOrigin = "anonymous";
    img.src = dataURLForImage;
  });
}
const DEFAULT_ACCEPTED_IMG_TYPE = ["image/jpeg", "image/png", "image/gif", "image/svg+xml"];
const DEFAULT_ACCEPTED_VID_TYPE = ["video/mp4", "video/quicktime"];
async function isGifAnimated(file) {
  return await new Promise((resolve, reject) => {
    const reader = new FileReader();
    reader.onerror = () => reject(reader.error);
    reader.onload = () => {
      resolve(reader.result ? isAnimated(reader.result) : false);
    };
    reader.readAsArrayBuffer(file);
  });
}
export {
  DEFAULT_ACCEPTED_IMG_TYPE,
  DEFAULT_ACCEPTED_VID_TYPE,
  containBoxSize,
  getResizedImageDataUrl,
  isGifAnimated
};
//# sourceMappingURL=assets.mjs.map
