"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var MoveToPageMenu_exports = {};
__export(MoveToPageMenu_exports, {
  MoveToPageMenu: () => MoveToPageMenu
});
module.exports = __toCommonJS(MoveToPageMenu_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var _ContextMenu = __toESM(require("@radix-ui/react-context-menu"));
var import_editor = require("@tldraw/editor");
var import_useToastsProvider = require("../hooks/useToastsProvider");
var import_useTranslation = require("../hooks/useTranslation/useTranslation");
var import_Button = require("./primitives/Button");
const MoveToPageMenu = (0, import_editor.track)(function MoveToPageMenu2() {
  const editor = (0, import_editor.useEditor)();
  const container = (0, import_editor.useContainer)();
  const pages = editor.pages;
  const currentPageId = editor.currentPageId;
  const msg = (0, import_useTranslation.useTranslation)();
  const { addToast } = (0, import_useToastsProvider.useToasts)();
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(_ContextMenu.Sub, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(_ContextMenu.SubTrigger, { dir: "ltr", asChild: true, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_Button.Button,
      {
        className: "tlui-menu__button",
        label: "context-menu.move-to-page",
        "data-testid": "menu-item.move-to-page",
        icon: "chevron-right"
      }
    ) }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(_ContextMenu.Portal, { container, dir: "ltr", children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(_ContextMenu.SubContent, { className: "tlui-menu", sideOffset: -4, collisionPadding: 4, children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        _ContextMenu.Group,
        {
          dir: "ltr",
          className: "tlui-menu__group",
          "data-testid": `menu-item.pages`,
          children: pages.map((page) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
            _ContextMenu.Item,
            {
              disabled: currentPageId === page.id,
              onSelect: () => {
                editor.mark("move_shapes_to_page");
                editor.moveShapesToPage(editor.selectedShapeIds, page.id);
                const toPage = editor.getPage(page.id);
                if (toPage) {
                  addToast({
                    title: "Changed Page",
                    description: `Moved to ${toPage.name}.`,
                    actions: [
                      {
                        label: "Go Back",
                        type: "primary",
                        onClick: () => {
                          editor.mark("change-page");
                          editor.setCurrentPage(currentPageId);
                        }
                      }
                    ]
                  });
                }
              },
              asChild: true,
              children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
                import_Button.Button,
                {
                  title: page.name,
                  className: "tlui-menu__button tlui-context-menu__move-to-page__name",
                  children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { children: page.name })
                }
              )
            },
            page.id
          ))
        },
        "pages"
      ),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        _ContextMenu.Group,
        {
          dir: "ltr",
          className: "tlui-menu__group",
          "data-testid": `menu-item.new-page`,
          children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
            _ContextMenu.Item,
            {
              onSelect: () => {
                const newPageId = import_editor.PageRecordType.createId();
                const ids = editor.selectedShapeIds;
                editor.batch(() => {
                  editor.mark("move_shapes_to_page");
                  editor.createPage({ name: "Page", id: newPageId });
                  editor.moveShapesToPage(ids, newPageId);
                });
              },
              asChild: true,
              children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
                import_Button.Button,
                {
                  title: msg("context.pages.new-page"),
                  className: "tlui-menu__button tlui-context-menu__move-to-page__name",
                  children: msg("context.pages.new-page")
                }
              )
            },
            "new-page"
          )
        },
        "new-page"
      )
    ] }) })
  ] });
});
//# sourceMappingURL=MoveToPageMenu.js.map
