"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var BackToContent_exports = {};
__export(BackToContent_exports, {
  BackToContent: () => BackToContent
});
module.exports = __toCommonJS(BackToContent_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_react = require("react");
var import_useActions = require("../hooks/useActions");
var import_Button = require("./primitives/Button");
function BackToContent() {
  const editor = (0, import_editor.useEditor)();
  const actions = (0, import_useActions.useActions)();
  const action = actions["back-to-content"];
  const [showBackToContent, setShowBackToContent] = (0, import_react.useState)(false);
  (0, import_react.useEffect)(() => {
    let showBackToContentPrev = false;
    const interval = setInterval(() => {
      const { renderingShapes, renderingBounds } = editor;
      const visibleShapes = renderingShapes.filter(
        (s) => s.maskedPageBounds && renderingBounds.includes(s.maskedPageBounds)
      );
      const showBackToContentNow = visibleShapes.length === 0 && editor.currentPageShapes.length > 0;
      if (showBackToContentPrev !== showBackToContentNow) {
        setShowBackToContent(showBackToContentNow);
        showBackToContentPrev = showBackToContentNow;
      }
    }, 1e3);
    return () => {
      clearInterval(interval);
    };
  }, [editor]);
  if (!showBackToContent)
    return null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_Button.Button,
    {
      iconLeft: action.icon,
      label: action.label,
      onClick: () => {
        action.onSelect("helper-buttons");
        setShowBackToContent(false);
      }
    }
  );
}
//# sourceMappingURL=BackToContent.js.map
