"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var EditLinkDialog_exports = {};
__export(EditLinkDialog_exports, {
  EditLinkDialog: () => EditLinkDialog,
  EditLinkDialogInner: () => EditLinkDialogInner
});
module.exports = __toCommonJS(EditLinkDialog_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_react = require("react");
var import_useTranslation = require("../hooks/useTranslation/useTranslation");
var import_Button = require("./primitives/Button");
var Dialog = __toESM(require("./primitives/Dialog"));
var import_Input = require("./primitives/Input");
function validateUrl(url) {
  if ((0, import_editor.isValidUrl)(url)) {
    return { isValid: true, hasProtocol: true };
  }
  if ((0, import_editor.isValidUrl)("https://" + url)) {
    return { isValid: true, hasProtocol: false };
  }
  return { isValid: false, hasProtocol: false };
}
const EditLinkDialog = (0, import_editor.track)(function EditLinkDialog2({ onClose }) {
  const editor = (0, import_editor.useEditor)();
  const selectedShape = editor.onlySelectedShape;
  if (!(selectedShape && "url" in selectedShape.props && typeof selectedShape.props.url === "string")) {
    return null;
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(EditLinkDialogInner, { onClose, selectedShape });
});
const EditLinkDialogInner = (0, import_editor.track)(function EditLinkDialogInner2({
  onClose,
  selectedShape
}) {
  const editor = (0, import_editor.useEditor)();
  const msg = (0, import_useTranslation.useTranslation)();
  const rInput = (0, import_react.useRef)(null);
  (0, import_react.useEffect)(() => {
    requestAnimationFrame(() => rInput.current?.focus());
  }, []);
  const rInitialValue = (0, import_react.useRef)(selectedShape.props.url);
  const [urlInputState, setUrlInputState] = (0, import_react.useState)(() => {
    const urlValidResult = validateUrl(selectedShape.props.url);
    const initialValue = urlValidResult.isValid === true ? urlValidResult.hasProtocol ? selectedShape.props.url : "https://" + selectedShape.props.url : "https://";
    return {
      actual: initialValue,
      safe: initialValue,
      valid: true
    };
  });
  const handleChange = (0, import_react.useCallback)((rawValue) => {
    const fixedRawValue = rawValue.replace(/https?:\/\/(https?:\/\/)/, (_match, arg1) => {
      return arg1;
    });
    const urlValidResult = validateUrl(fixedRawValue);
    const safeValue = urlValidResult.isValid === true ? urlValidResult.hasProtocol ? fixedRawValue : "https://" + fixedRawValue : "https://";
    setUrlInputState({
      actual: fixedRawValue,
      safe: safeValue,
      valid: urlValidResult.isValid
    });
  }, []);
  const handleClear = (0, import_react.useCallback)(() => {
    const { onlySelectedShape } = editor;
    if (!onlySelectedShape)
      return;
    editor.updateShapes([
      { id: onlySelectedShape.id, type: onlySelectedShape.type, props: { url: "" } }
    ]);
    onClose();
  }, [editor, onClose]);
  const handleComplete = (0, import_react.useCallback)(() => {
    const { onlySelectedShape } = editor;
    if (!onlySelectedShape)
      return;
    if (onlySelectedShape && "url" in onlySelectedShape.props) {
      if (onlySelectedShape.props.url !== urlInputState.safe) {
        editor.updateShapes([
          {
            id: onlySelectedShape.id,
            type: onlySelectedShape.type,
            props: { url: urlInputState.safe }
          }
        ]);
      }
    }
    onClose();
  }, [editor, onClose, urlInputState]);
  const handleCancel = (0, import_react.useCallback)(() => {
    onClose();
  }, [onClose]);
  if (!selectedShape) {
    onClose();
    return null;
  }
  const isRemoving = rInitialValue.current && !urlInputState.valid;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_jsx_runtime.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(Dialog.Header, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Dialog.Title, { children: msg("edit-link-dialog.title") }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Dialog.CloseButton, {})
    ] }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Dialog.Body, { children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "tlui-edit-link-dialog", children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        import_Input.Input,
        {
          ref: rInput,
          className: "tlui-edit-link-dialog__input",
          label: "edit-link-dialog.url",
          autofocus: true,
          value: urlInputState.actual,
          onValueChange: handleChange,
          onComplete: handleComplete,
          onCancel: handleCancel
        }
      ),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { children: urlInputState.valid ? msg("edit-link-dialog.detail") : msg("edit-link-dialog.invalid-url") })
    ] }) }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(Dialog.Footer, { className: "tlui-dialog__footer__actions", children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Button.Button, { onClick: handleCancel, onTouchEnd: handleCancel, children: msg("edit-link-dialog.cancel") }),
      isRemoving ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Button.Button, { type: "danger", onTouchEnd: handleClear, onClick: handleClear, children: msg("edit-link-dialog.clear") }) : /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
        import_Button.Button,
        {
          type: "primary",
          disabled: !urlInputState.valid,
          onTouchEnd: handleComplete,
          onClick: handleComplete,
          children: msg("edit-link-dialog.save")
        }
      )
    ] })
  ] });
});
//# sourceMappingURL=EditLinkDialog.js.map
