"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var EmbedDialog_exports = {};
__export(EmbedDialog_exports, {
  EmbedDialog: () => EmbedDialog
});
module.exports = __toCommonJS(EmbedDialog_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_react = require("react");
var import_embeds = require("../../utils/embeds");
var import_useAssetUrls = require("../hooks/useAssetUrls");
var import_useTranslation = require("../hooks/useTranslation/useTranslation");
var import_Button = require("./primitives/Button");
var Dialog = __toESM(require("./primitives/Dialog"));
var import_Icon = require("./primitives/Icon");
var import_Input = require("./primitives/Input");
const EmbedDialog = (0, import_editor.track)(function EmbedDialog2({ onClose }) {
  const editor = (0, import_editor.useEditor)();
  const msg = (0, import_useTranslation.useTranslation)();
  const assetUrls = (0, import_useAssetUrls.useAssetUrls)();
  const [embedDefinition, setEmbedDefinition] = (0, import_react.useState)(null);
  const [url, setUrl] = (0, import_react.useState)("");
  const [embedInfoForUrl, setEmbedInfoForUrl] = (0, import_react.useState)(null);
  const [showError, setShowError] = (0, import_react.useState)(false);
  const rShowErrorTimeout = (0, import_react.useRef)(-1);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_jsx_runtime.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(Dialog.Header, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Dialog.Title, { children: embedDefinition ? `${msg("embed-dialog.title")} \u2014 ${embedDefinition.title}` : msg("embed-dialog.title") }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Dialog.CloseButton, {})
    ] }),
    embedDefinition ? /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_jsx_runtime.Fragment, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(Dialog.Body, { className: "tlui-embed-dialog__enter", children: [
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          import_Input.Input,
          {
            className: "tlui-embed-dialog__input",
            label: "embed-dialog.url",
            placeholder: "http://example.com",
            autofocus: true,
            onValueChange: (value) => {
              setUrl(value);
              const embedInfo = (0, import_embeds.getEmbedInfo)(value);
              setEmbedInfoForUrl(
                embedInfo && embedInfo.definition.type === embedDefinition.type ? embedInfo : null
              );
              setShowError(false);
              clearTimeout(rShowErrorTimeout.current);
              rShowErrorTimeout.current = setTimeout(() => setShowError(!embedInfo), 320);
            }
          }
        ),
        url === "" ? /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "tlui-embed-dialog__instruction", children: [
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { children: msg("embed-dialog.instruction") }),
          " ",
          embedDefinition.instructionLink && /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
            "a",
            {
              target: "_blank",
              rel: "noopener noreferrer",
              href: embedDefinition.instructionLink,
              className: "tlui-embed-dialog__instruction__link",
              children: [
                "Learn more.",
                /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Icon.Icon, { icon: "external-link", small: true })
              ]
            }
          )
        ] }) : /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tlui-embed-dialog__warning", children: showError ? msg("embed-dialog.invalid-url") : "\xA0" })
      ] }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(Dialog.Footer, { className: "tlui-dialog__footer__actions", children: [
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          import_Button.Button,
          {
            onClick: () => {
              setEmbedDefinition(null);
              setEmbedInfoForUrl(null);
              setUrl("");
            },
            label: "embed-dialog.back"
          }
        ),
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tlui-embed__spacer" }),
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_Button.Button, { label: "embed-dialog.cancel", onClick: onClose }),
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          import_Button.Button,
          {
            type: "primary",
            disabled: !embedInfoForUrl,
            label: "embed-dialog.create",
            onClick: () => {
              if (!embedInfoForUrl)
                return;
              editor.putExternalContent({
                type: "embed",
                url,
                point: editor.viewportPageCenter,
                embed: embedInfoForUrl.definition
              });
              onClose();
            }
          }
        )
      ] })
    ] }) : /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_jsx_runtime.Fragment, { children: [
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Dialog.Body, { className: "tlui-embed-dialog__list", children: import_editor.EMBED_DEFINITIONS.map((def) => {
        return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
          "button",
          {
            className: "tlui-embed-dialog__item",
            onClick: () => setEmbedDefinition(def),
            children: [
              /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tlui-embed-dialog__item__image", children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
                "div",
                {
                  className: "tlui-embed-dialog__item__image__img",
                  style: {
                    backgroundImage: `url(${assetUrls.embedIcons[def.type]})`
                  }
                }
              ) }),
              /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tlui-embed-dialog__item__title", children: def.title })
            ]
          },
          def.type
        );
      }) }),
      /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tlui-dialog__scrim" })
    ] })
  ] });
});
//# sourceMappingURL=EmbedDialog.js.map
