import { Box2d, StateNode } from "@tldraw/editor";
class ZoomBrushing extends StateNode {
  static id = "zoom_brushing";
  info = {};
  zoomBrush = new Box2d();
  onEnter = (info) => {
    this.info = info;
    this.update();
  };
  onExit = () => {
    this.editor.updateInstanceState({ zoomBrush: null });
  };
  onPointerMove = () => {
    this.update();
  };
  onPointerUp = () => {
    this.complete();
  };
  onCancel = () => {
    this.cancel();
  };
  update() {
    const {
      inputs: { originPagePoint, currentPagePoint }
    } = this.editor;
    this.zoomBrush.setTo(Box2d.FromPoints([originPagePoint, currentPagePoint]));
    this.editor.updateInstanceState({ zoomBrush: this.zoomBrush.toJson() });
  }
  cancel() {
    this.parent.transition("idle", this.info);
  }
  complete() {
    const { zoomBrush } = this;
    const threshold = 8 / this.editor.zoomLevel;
    if (zoomBrush.width < threshold && zoomBrush.height < threshold) {
      const point = this.editor.inputs.currentScreenPoint;
      if (this.editor.inputs.altKey) {
        this.editor.zoomOut(point, { duration: 220 });
      } else {
        this.editor.zoomIn(point, { duration: 220 });
      }
    } else {
      const zoomLevel = this.editor.inputs.altKey ? this.editor.zoomLevel / 2 : void 0;
      this.editor.zoomToBounds(zoomBrush, zoomLevel, { duration: 220 });
    }
    this.parent.transition("idle", this.info);
  }
}
export {
  ZoomBrushing
};
//# sourceMappingURL=ZoomBrushing.mjs.map
