import { jsx, jsxs } from "react/jsx-runtime";
import * as PopoverPrimitive from "@radix-ui/react-popover";
import { useContainer } from "@tldraw/editor";
import { memo } from "react";
import { useActionsMenuSchema } from "../hooks/useActionsMenuSchema.mjs";
import { useReadonly } from "../hooks/useReadonly.mjs";
import { useTranslation } from "../hooks/useTranslation/useTranslation.mjs";
import { Button } from "./primitives/Button.mjs";
import { Popover, PopoverTrigger } from "./primitives/Popover.mjs";
import { kbdStr } from "./primitives/shared.mjs";
const ActionsMenu = memo(function ActionsMenu2() {
  const msg = useTranslation();
  const container = useContainer();
  const menuSchema = useActionsMenuSchema();
  const isReadonly = useReadonly();
  function getActionMenuItem(item) {
    if (isReadonly && !item.readonlyOk)
      return null;
    switch (item.type) {
      case "item": {
        const { id, icon, label, kbd, onSelect } = item.actionItem;
        return /* @__PURE__ */ jsx(
          Button,
          {
            className: "tlui-button-grid__button",
            "data-testid": `menu-item.${item.id}`,
            icon,
            title: label ? kbd ? `${msg(label)} ${kbdStr(kbd)}` : `${msg(label)}` : kbd ? `${kbdStr(kbd)}` : "",
            onClick: () => onSelect("actions-menu"),
            disabled: item.disabled
          },
          id
        );
      }
    }
  }
  return /* @__PURE__ */ jsxs(Popover, { id: "actions menu", children: [
    /* @__PURE__ */ jsx(PopoverTrigger, { children: /* @__PURE__ */ jsx(
      Button,
      {
        className: "tlui-menu__trigger",
        "data-testid": "main.action-menu",
        icon: "dots-vertical",
        title: msg("actions-menu.title"),
        smallIcon: true
      }
    ) }),
    /* @__PURE__ */ jsx(PopoverPrimitive.Portal, { dir: "ltr", container, children: /* @__PURE__ */ jsx(
      PopoverPrimitive.Content,
      {
        className: "tlui-popover__content",
        side: "bottom",
        dir: "ltr",
        sideOffset: 6,
        children: /* @__PURE__ */ jsx("div", { className: "tlui-actions-menu tlui-button-grid__four", children: menuSchema.map(getActionMenuItem) })
      }
    ) })
  ] });
});
export {
  ActionsMenu
};
//# sourceMappingURL=ActionsMenu.mjs.map
