import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import { useKeyboardShortcutsSchema } from "../hooks/useKeyboardShortcutsSchema.mjs";
import { useReadonly } from "../hooks/useReadonly.mjs";
import { useTranslation } from "../hooks/useTranslation/useTranslation.mjs";
import * as Dialog from "./primitives/Dialog.mjs";
import { Kbd } from "./primitives/Kbd.mjs";
const KeyboardShortcutsDialog = () => {
  const msg = useTranslation();
  const isReadonly = useReadonly();
  const shortcutsItems = useKeyboardShortcutsSchema();
  function getKeyboardShortcutItem(item) {
    if (isReadonly && !item.readonlyOk)
      return null;
    switch (item.type) {
      case "group": {
        return /* @__PURE__ */ jsxs("div", { className: "tlui-shortcuts-dialog__group", children: [
          /* @__PURE__ */ jsx("h2", { className: "tlui-shortcuts-dialog__group__title", children: msg(item.id) }),
          /* @__PURE__ */ jsx("div", { className: "tlui-shortcuts-dialog__group__content", children: item.children.filter((item2) => item2.type === "item" && item2.actionItem.kbd).map(getKeyboardShortcutItem) })
        ] }, item.id);
      }
      case "item": {
        const { id, label, shortcutsLabel, kbd } = item.actionItem;
        return /* @__PURE__ */ jsxs("div", { className: "tlui-shortcuts-dialog__key-pair", children: [
          /* @__PURE__ */ jsx("div", { className: "tlui-shortcuts-dialog__key-pair__key", children: msg(shortcutsLabel ?? label) }),
          /* @__PURE__ */ jsx("div", { className: "tlui-shortcuts-dialog__key-pair__value", children: /* @__PURE__ */ jsx(Kbd, { children: kbd }) })
        ] }, id);
      }
    }
  }
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(Dialog.Header, { className: "tlui-shortcuts-dialog__header", children: [
      /* @__PURE__ */ jsx(Dialog.Title, { children: msg("shortcuts-dialog.title") }),
      /* @__PURE__ */ jsx(Dialog.CloseButton, {})
    ] }),
    /* @__PURE__ */ jsx(Dialog.Body, { className: "tlui-shortcuts-dialog__body", children: shortcutsItems.map(getKeyboardShortcutItem) }),
    /* @__PURE__ */ jsx("div", { className: "tlui-dialog__scrim" })
  ] });
};
export {
  KeyboardShortcutsDialog
};
//# sourceMappingURL=KeyboardShortcutsDialog.mjs.map
