import { jsx, jsxs } from "react/jsx-runtime";
import {
  DefaultColorStyle,
  getDefaultColorTheme,
  useEditor,
  useValue
} from "@tldraw/editor";
import { useCallback } from "react";
import { useOpenMenuCloser } from "../hooks/useOpenMenuCloser.mjs";
import { useRelevantStyles } from "../hooks/useRevelantStyles.mjs";
import { useTranslation } from "../hooks/useTranslation/useTranslation.mjs";
import { StylePanel } from "./StylePanel/StylePanel.mjs";
import { Button } from "./primitives/Button.mjs";
import { Icon } from "./primitives/Icon.mjs";
import { Popover, PopoverContent, PopoverTrigger } from "./primitives/Popover.mjs";
function MobileStylePanel() {
  const editor = useEditor();
  const msg = useTranslation();
  const relevantStyles = useRelevantStyles();
  const color = relevantStyles?.styles.get(DefaultColorStyle);
  const theme = getDefaultColorTheme({ isDarkMode: editor.user.isDarkMode });
  const currentColor = (color?.type === "shared" ? theme[color.value] : theme.black).solid;
  const disableStylePanel = useValue(
    "isHandOrEraserToolActive",
    () => editor.isInAny("hand", "zoom", "eraser", "laser"),
    [editor]
  );
  const handleStylesOpenChange = useCallback(
    (isOpen) => {
      if (!isOpen) {
        editor.updateInstanceState({ isChangingStyle: false });
      }
    },
    [editor]
  );
  const extraEventsToToggleMenu = useOpenMenuCloser();
  return /* @__PURE__ */ jsxs(Popover, { id: "style menu", onOpenChange: handleStylesOpenChange, children: [
    /* @__PURE__ */ jsx(PopoverTrigger, { disabled: disableStylePanel, children: /* @__PURE__ */ jsx(
      Button,
      {
        className: "tlui-toolbar__tools__button tlui-toolbar__styles__button",
        "data-testid": "mobile.styles",
        style: {
          color: disableStylePanel ? "var(--color-muted-1)" : currentColor
        },
        title: msg("style-panel.title"),
        ...extraEventsToToggleMenu,
        children: /* @__PURE__ */ jsx(Icon, { icon: disableStylePanel ? "blob" : color?.type === "mixed" ? "mixed" : "blob" })
      }
    ) }),
    /* @__PURE__ */ jsx(PopoverContent, { side: "top", align: "end", children: /* @__PURE__ */ jsx(StylePanel, { isMobile: true }) })
  ] });
}
export {
  MobileStylePanel
};
//# sourceMappingURL=MobileStylePanel.mjs.map
