import { jsx, jsxs } from "react/jsx-runtime";
import classNames from "classnames";
import { useRef } from "react";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { Icon } from "../primitives/Icon.mjs";
function OfflineIndicator() {
  const msg = useTranslation();
  const rContainer = useRef(null);
  return /* @__PURE__ */ jsxs("div", { className: classNames("tlui-offline-indicator"), ref: rContainer, children: [
    msg("status.offline"),
    /* @__PURE__ */ jsx(Icon, { "aria-label": "offline", icon: "status-offline", small: true })
  ] });
}
export {
  OfflineIndicator
};
//# sourceMappingURL=OfflineIndicator.mjs.map
