import { jsx, jsxs } from "react/jsx-runtime";
import classnames from "classnames";
import * as React from "react";
import { useTranslation } from "../../hooks/useTranslation/useTranslation.mjs";
import { Spinner } from "../Spinner.mjs";
import { Icon } from "./Icon.mjs";
import { Kbd } from "./Kbd.mjs";
const Button = React.forwardRef(function Button2({
  label,
  icon,
  invertIcon,
  iconLeft,
  smallIcon,
  kbd,
  isChecked = false,
  type = "normal",
  children,
  spinner,
  ...props
}, ref) {
  const msg = useTranslation();
  const labelStr = label ? msg(label) : "";
  return /* @__PURE__ */ jsxs(
    "button",
    {
      ref,
      draggable: false,
      type: "button",
      ...props,
      title: props.title ?? labelStr,
      className: classnames("tlui-button", `tlui-button__${type}`, props.className),
      children: [
        iconLeft && /* @__PURE__ */ jsx(Icon, { icon: iconLeft, className: "tlui-icon-left", small: true }),
        children,
        label && /* @__PURE__ */ jsxs("span", { draggable: false, children: [
          labelStr,
          isChecked && /* @__PURE__ */ jsx(Icon, { icon: "check" })
        ] }),
        kbd && /* @__PURE__ */ jsx(Kbd, { children: kbd }),
        icon && !spinner && /* @__PURE__ */ jsx(Icon, { icon, small: !!label || smallIcon, invertIcon }),
        spinner && /* @__PURE__ */ jsx(Spinner, {})
      ]
    }
  );
});
export {
  Button
};
//# sourceMappingURL=Button.mjs.map
