import { jsx } from "react/jsx-runtime";
import { compact, track, useEditor } from "@tldraw/editor";
import React, { useMemo } from "react";
import { KeyboardShortcutsDialog } from "../components/KeyboardShortcutsDialog.mjs";
import { menuCustom, menuGroup, menuItem } from "./menuHelpers.mjs";
import { useActions } from "./useActions.mjs";
import { useDialogs } from "./useDialogsProvider.mjs";
import { useLanguages } from "./useTranslation/useLanguages.mjs";
const HelpMenuSchemaContext = React.createContext({});
const HelpMenuSchemaProvider = track(function HelpMenuSchemaProvider2({
  overrides,
  children
}) {
  const editor = useEditor();
  const actions = useActions();
  const selectedCount = editor.selectedShapeIds.length;
  const oneSelected = selectedCount > 0;
  const twoSelected = selectedCount > 1;
  const threeSelected = selectedCount > 2;
  const { languages, currentLanguage } = useLanguages();
  const { addDialog } = useDialogs();
  const helpTLUiMenuSchema = useMemo(() => {
    const helpTLUiMenuSchema2 = compact([
      menuGroup(
        "top",
        menuCustom("LANGUAGE_MENU", { readonlyOk: true }),
        menuItem({
          id: "keyboard-shortcuts",
          label: "help-menu.keyboard-shortcuts",
          readonlyOk: true,
          onSelect() {
            addDialog({ component: KeyboardShortcutsDialog });
          }
        })
      )
    ]);
    if (overrides) {
      return overrides(editor, helpTLUiMenuSchema2, {
        actions,
        currentLanguage,
        languages,
        oneSelected,
        twoSelected,
        threeSelected
      });
    }
    return helpTLUiMenuSchema2;
  }, [
    editor,
    overrides,
    languages,
    actions,
    oneSelected,
    twoSelected,
    threeSelected,
    currentLanguage,
    addDialog
  ]);
  return /* @__PURE__ */ jsx(HelpMenuSchemaContext.Provider, { value: helpTLUiMenuSchema, children });
});
function useHelpMenuSchema() {
  const ctx = React.useContext(HelpMenuSchemaContext);
  if (!ctx) {
    throw new Error("useHelpMenuSchema must be used inside of a helpTLUiMenuSchemaProvider.");
  }
  return ctx;
}
export {
  HelpMenuSchemaContext,
  HelpMenuSchemaProvider,
  useHelpMenuSchema
};
//# sourceMappingURL=useHelpMenuSchema.mjs.map
