import { StateNode } from "@tldraw/editor";
import { ScribbleManager } from "../../../shapes/shared/ScribbleManager.mjs";
class Lasering extends StateNode {
  static id = "lasering";
  scribble = {};
  onEnter = () => {
    this.startScribble();
    this.pushPointToScribble();
  };
  onExit = () => {
    this.scribble.stop();
  };
  onPointerMove = () => {
    this.pushPointToScribble();
  };
  onPointerUp = () => {
    this.complete();
  };
  startScribble = () => {
    if (this.scribble.tick) {
      this.editor.off("tick", this.scribble?.tick);
    }
    this.scribble = new ScribbleManager({
      onUpdate: this.onScribbleUpdate,
      onComplete: this.onScribbleComplete,
      color: "laser",
      opacity: 0.7,
      size: 4,
      delay: 1200
    });
    this.editor.on("tick", this.scribble.tick);
  };
  pushPointToScribble = () => {
    const { x, y } = this.editor.inputs.currentPagePoint;
    this.scribble.addPoint(x, y);
  };
  onScribbleUpdate = (scribble) => {
    this.editor.updateInstanceState({ scribble });
  };
  onScribbleComplete = () => {
    this.editor.off("tick", this.scribble.tick);
    this.editor.updateInstanceState({ scribble: null });
  };
  onCancel = () => {
    this.cancel();
  };
  onComplete = () => {
    this.complete();
  };
  complete() {
    this.parent.transition("idle", {});
  }
  cancel() {
    this.parent.transition("idle", {});
  }
}
export {
  Lasering
};
//# sourceMappingURL=Lasering.mjs.map
