import { EASINGS, StateNode } from "@tldraw/editor";
import { Dragging } from "./children/Dragging.mjs";
import { Idle } from "./children/Idle.mjs";
import { Pointing } from "./children/Pointing.mjs";
class HandTool extends StateNode {
  static id = "hand";
  static initial = "idle";
  static children = () => [Idle, Pointing, Dragging];
  onDoubleClick = (info) => {
    if (info.phase === "settle") {
      const { currentScreenPoint } = this.editor.inputs;
      this.editor.zoomIn(currentScreenPoint, { duration: 220, easing: EASINGS.easeOutQuint });
    }
  };
  onTripleClick = (info) => {
    if (info.phase === "settle") {
      const { currentScreenPoint } = this.editor.inputs;
      this.editor.zoomOut(currentScreenPoint, { duration: 320, easing: EASINGS.easeOutQuint });
    }
  };
  onQuadrupleClick = (info) => {
    if (info.phase === "settle") {
      const {
        zoomLevel,
        inputs: { currentScreenPoint }
      } = this.editor;
      if (zoomLevel === 1) {
        this.editor.zoomToFit({ duration: 400, easing: EASINGS.easeOutQuint });
      } else {
        this.editor.resetZoom(currentScreenPoint, { duration: 320, easing: EASINGS.easeOutQuint });
      }
    }
  };
}
export {
  HandTool
};
//# sourceMappingURL=HandTool.mjs.map
