import { jsx, jsxs } from "react/jsx-runtime";
import { useEditor } from "@tldraw/editor";
import { useCallback } from "react";
import { useLanguages } from "../hooks/useTranslation/useLanguages.mjs";
import * as D from "./primitives/DropdownMenu.mjs";
function LanguageMenu() {
  const editor = useEditor();
  const { languages, currentLanguage } = useLanguages();
  const handleLanguageSelect = useCallback(
    (locale) => editor.user.updateUserPreferences({ locale }),
    [editor]
  );
  return /* @__PURE__ */ jsxs(D.Sub, { id: "help menu language", children: [
    /* @__PURE__ */ jsx(D.SubTrigger, { label: "menu.language", "data-direction": "left" }),
    /* @__PURE__ */ jsx(D.SubContent, { sideOffset: -4, children: /* @__PURE__ */ jsx(D.Group, { children: languages.map(({ locale, label }) => /* @__PURE__ */ jsx(
      D.RadioItem,
      {
        title: locale,
        checked: locale === currentLanguage,
        onSelect: () => handleLanguageSelect(locale),
        children: /* @__PURE__ */ jsx("span", { children: label })
      },
      locale
    )) }) })
  ] });
}
export {
  LanguageMenu
};
//# sourceMappingURL=LanguageMenu.mjs.map
