import { Fragment, jsx, jsxs } from "react/jsx-runtime";
import { track, useEditor } from "@tldraw/editor";
import { useBreakpoint } from "../hooks/useBreakpoint.mjs";
import { useReadonly } from "../hooks/useReadonly.mjs";
import { ActionsMenu } from "./ActionsMenu.mjs";
import { DuplicateButton } from "./DuplicateButton.mjs";
import { Menu } from "./Menu.mjs";
import { PageMenu } from "./PageMenu/PageMenu.mjs";
import { RedoButton } from "./RedoButton.mjs";
import { TrashButton } from "./TrashButton.mjs";
import { UndoButton } from "./UndoButton.mjs";
const MenuZone = track(function MenuZone2() {
  const editor = useEditor();
  const breakpoint = useBreakpoint();
  const isReadonly = useReadonly();
  return /* @__PURE__ */ jsx("div", { className: "tlui-menu-zone", children: /* @__PURE__ */ jsxs("div", { className: "tlui-menu-zone__controls", children: [
    /* @__PURE__ */ jsx(Menu, {}),
    /* @__PURE__ */ jsx("div", { className: "tlui-menu-zone__divider" }),
    /* @__PURE__ */ jsx(PageMenu, {}),
    breakpoint >= 6 && !isReadonly && !editor.isInAny("hand", "zoom") && /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx("div", { className: "tlui-menu-zone__divider" }),
      /* @__PURE__ */ jsx(UndoButton, {}),
      /* @__PURE__ */ jsx(RedoButton, {}),
      /* @__PURE__ */ jsx(TrashButton, {}),
      /* @__PURE__ */ jsx(DuplicateButton, {}),
      /* @__PURE__ */ jsx(ActionsMenu, {})
    ] })
  ] }) });
});
export {
  MenuZone
};
//# sourceMappingURL=MenuZone.mjs.map
