import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Tldraw, track, useEditor } from "@tldraw/tldraw";
import "@tldraw/tldraw/tldraw.css";
import { useAutomergeStore } from "./useAutomergeStore.js";
export function TLDrawAutomergeExample({ handle, userId, }) {
    const store = useAutomergeStore({ handle, userId });
    return (_jsx("div", { className: "tldraw__editor", children: _jsx(Tldraw, { autoFocus: true, store: store, shareZone: _jsx(NameEditor, {}) }) }));
}
const NameEditor = track(() => {
    const editor = useEditor();
    const { color, name } = editor.user;
    return (_jsxs("div", { style: { pointerEvents: "all", display: "flex" }, children: [_jsx("input", { type: "color", value: color, onChange: (e) => {
                    editor.user.updateUserPreferences({
                        color: e.currentTarget.value,
                    });
                } }), _jsx("input", { value: name, onChange: (e) => {
                    editor.user.updateUserPreferences({
                        name: e.currentTarget.value,
                    });
                } })] }));
});
