import { ROOT_ID } from "../data/create-root";
export class NodeApi {
    constructor(params) {
        this.handleClick = (e) => {
            if (e.metaKey && !this.tree.props.disableMultiSelection) {
                this.isSelected ? this.deselect() : this.selectMulti();
            }
            else if (e.shiftKey && !this.tree.props.disableMultiSelection) {
                this.selectContiguous();
            }
            else {
                this.select();
                this.activate();
            }
        };
        this.tree = params.tree;
        this.id = params.id;
        this.data = params.data;
        this.level = params.level;
        this.children = params.children;
        this.parent = params.parent;
        this.isDraggable = params.isDraggable;
        this.rowIndex = params.rowIndex;
    }
    get isRoot() {
        return this.id === ROOT_ID;
    }
    get isLeaf() {
        return !Array.isArray(this.children);
    }
    get isInternal() {
        return !this.isLeaf;
    }
    get isOpen() {
        return this.isLeaf ? false : this.tree.isOpen(this.id);
    }
    get isClosed() {
        return this.isLeaf ? false : !this.tree.isOpen(this.id);
    }
    get isEditable() {
        return this.tree.isEditable(this.data);
    }
    get isEditing() {
        return this.tree.editingId === this.id;
    }
    get isSelected() {
        return this.tree.isSelected(this.id);
    }
    get isOnlySelection() {
        return this.isSelected && this.tree.hasOneSelection;
    }
    get isSelectedStart() {
        var _a;
        return this.isSelected && !((_a = this.prev) === null || _a === void 0 ? void 0 : _a.isSelected);
    }
    get isSelectedEnd() {
        var _a;
        return this.isSelected && !((_a = this.next) === null || _a === void 0 ? void 0 : _a.isSelected);
    }
    get isFocused() {
        return this.tree.isFocused(this.id);
    }
    get isDragging() {
        return this.tree.isDragging(this.id);
    }
    get willReceiveDrop() {
        return this.tree.willReceiveDrop(this.id);
    }
    get state() {
        return {
            isClosed: this.isClosed,
            isDragging: this.isDragging,
            isEditing: this.isEditing,
            isFocused: this.isFocused,
            isInternal: this.isInternal,
            isLeaf: this.isLeaf,
            isOpen: this.isOpen,
            isSelected: this.isSelected,
            isSelectedEnd: this.isSelectedEnd,
            isSelectedStart: this.isSelectedStart,
            willReceiveDrop: this.willReceiveDrop,
        };
    }
    get childIndex() {
        if (this.parent && this.parent.children) {
            return this.parent.children.findIndex((child) => child.id === this.id);
        }
        else {
            return -1;
        }
    }
    get next() {
        if (this.rowIndex === null)
            return null;
        return this.tree.at(this.rowIndex + 1);
    }
    get prev() {
        if (this.rowIndex === null)
            return null;
        return this.tree.at(this.rowIndex - 1);
    }
    get nextSibling() {
        var _a, _b;
        const i = this.childIndex;
        return (_b = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.children[i + 1]) !== null && _b !== void 0 ? _b : null;
    }
    isAncestorOf(node) {
        if (!node)
            return false;
        let ancestor = node;
        while (ancestor) {
            if (ancestor.id === this.id)
                return true;
            ancestor = ancestor.parent;
        }
        return false;
    }
    select() {
        this.tree.select(this);
    }
    deselect() {
        this.tree.deselect(this);
    }
    selectMulti() {
        this.tree.selectMulti(this);
    }
    selectContiguous() {
        this.tree.selectContiguous(this);
    }
    activate() {
        this.tree.activate(this);
    }
    focus() {
        this.tree.focus(this);
    }
    toggle() {
        this.tree.toggle(this);
    }
    open() {
        this.tree.open(this);
    }
    openParents() {
        this.tree.openParents(this);
    }
    close() {
        this.tree.close(this);
    }
    submit(value) {
        this.tree.submit(this, value);
    }
    reset() {
        this.tree.reset();
    }
    clone() {
        return new NodeApi(Object.assign({}, this));
    }
    edit() {
        return this.tree.edit(this);
    }
}
