"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveImport = resolveImport;
const path_1 = require("path");
function resolveImport(base, imported) {
    // Skip external packages
    if (!(imported.startsWith("./") || imported.startsWith("../")))
        return null;
    return path_1.posix.join(path_1.posix.dirname(base), imported);
}
